/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.json.JSONException;
import org.json.JSONWriter;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.PrintException;
import org.mapfish.print.output.OutputFactory;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.utils.PJsonObject;
import org.pvalsecc.misc.FileUtilities;
import org.pvalsecc.opts.GetOptions;
import org.pvalsecc.opts.InvalidOption;
import org.pvalsecc.opts.Option;

public class ShellMapPrinter {
    public static final Logger LOGGER = Logger.getLogger(ShellMapPrinter.class);
    @Option(desc="Filename for the configuration (templates&CO)", mandatory=true)
    private String config = null;
    @Option(desc="The location of the description of what has to be printed. By default, STDIN")
    private String spec = null;
    @Option(desc="Used only if log4jConfig is not specified. 3 if you want everything, 2 if you want the debug information (stacktraces are shown), 1 for infos and 0 for only warnings and errors")
    private int verbose = 1;
    @Option(desc="The destination file. By default, STDOUT")
    private String output = null;
    @Option(desc="Get the config for the client form. Doesn't generate a PDF")
    private boolean clientConfig = false;
    @Option(desc="Referer address to use when doing queries")
    private String referer = null;
    @Option(desc="Property file for the log4j configuration")
    private String log4jConfig = null;
    private final MapPrinter printer;

    public ShellMapPrinter(String[] args) throws IOException {
        try {
            GetOptions.parse(args, this);
        }
        catch (InvalidOption invalidOption) {
            this.help(invalidOption.getMessage());
        }
        this.configureLogs();
        this.printer = new MapPrinter(new File(this.config));
    }

    private void help(String message) {
        System.err.println(message);
        System.err.println();
        System.err.println("Usage:");
        System.err.println("  " + this.getClass().getName() + " " + GetOptions.getShortList(this));
        System.err.println("Params:");
        try {
            System.err.println(GetOptions.getLongList(this));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(System.err);
        }
        System.exit(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException, JSONException, DocumentException {
        OutputStream outFile = null;
        try {
            if (this.clientConfig) {
                outFile = this.getOutputStream("");
                OutputStreamWriter writer = new OutputStreamWriter(outFile, Charset.forName("UTF-8"));
                JSONWriter json = new JSONWriter((Writer)writer);
                json.object();
                this.printer.printClientConfig(json);
                json.endObject();
                writer.close();
            } else {
                InputStream inFile = this.getInputStream();
                PJsonObject jsonSpec = MapPrinter.parseSpec(FileUtilities.readWholeTextStream(inFile, "UTF-8"));
                OutputFormat outputFormat = OutputFactory.create(this.printer.getConfig(), jsonSpec);
                outFile = this.getOutputStream(jsonSpec.optString("outputFormat", "pdf"));
                outputFormat.print(this.printer, jsonSpec, outFile, this.referer);
            }
        }
        finally {
            if (outFile != null) {
                outFile.close();
            }
            if (this.printer != null) {
                this.printer.stop();
            }
        }
    }

    private void configureLogs() {
        if (this.log4jConfig != null) {
            PropertyConfigurator.configure((String)this.log4jConfig);
        } else {
            Level level;
            ConsoleAppender appender = new ConsoleAppender((Layout)new PatternLayout("%d{HH:mm:ss.SSS} [%t] %-5p %30.30c - %m%n"), "system.err");
            BasicConfigurator.configure((Appender)appender);
            switch (this.verbose) {
                case 0: {
                    level = Level.WARN;
                    break;
                }
                case 1: {
                    level = Level.INFO;
                    break;
                }
                case 2: {
                    level = Level.DEBUG;
                    Logger.getLogger((String)"httpclient").setLevel(Level.INFO);
                    Logger.getLogger((String)"org.apache.commons.httpclient").setLevel(Level.INFO);
                    Logger.getLogger((String)"org.apache.pdfbox").setLevel(Level.INFO);
                    break;
                }
                default: {
                    level = Level.TRACE;
                }
            }
            Logger.getRootLogger().setLevel(level);
        }
    }

    private OutputStream getOutputStream(String suffix) throws FileNotFoundException {
        OutputStream outFile;
        if (this.output != null) {
            if (!this.output.endsWith("." + suffix)) {
                this.output = this.output + "." + suffix;
            }
            outFile = new FileOutputStream(this.output);
        } else {
            outFile = System.out;
        }
        return outFile;
    }

    private InputStream getInputStream() throws FileNotFoundException {
        InputStream file = this.spec != null ? new FileInputStream(this.spec) : System.in;
        return file;
    }

    public static void main(String[] args) throws IOException, JSONException, DocumentException {
        ShellMapPrinter app = new ShellMapPrinter(args);
        try {
            app.run();
        }
        catch (PrintException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error((Object)"Cannot generate PDF", (Throwable)e);
            } else {
                LOGGER.error((Object)e.toString());
            }
            System.exit(-2);
        }
    }
}

