/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.ho.yaml.exception.YamlException;
import org.ho.yaml.wrapper.AbstractWrapper;
import org.ho.yaml.wrapper.SimpleObjectWrapper;

public class ColorWrapper
extends AbstractWrapper
implements SimpleObjectWrapper {
    public ColorWrapper(Class<?> type) {
        super(type);
    }

    public void setObject(Object obj) {
        if (obj instanceof String) {
            super.setObject((Object)ColorWrapper.convertColor((String)obj));
        } else {
            super.setObject(obj);
        }
    }

    public Class<?> expectedArgType() {
        return String.class;
    }

    public Object getOutputValue() {
        return this.getObject().toString();
    }

    public static Color convertColor(String color) {
        if (color == null) {
            return null;
        }
        Color result = Color.getColor(color);
        if (result == null) {
            try {
                Long longval = Long.decode(color);
                long i = longval;
                result = i >= 0x1000000L ? new Color((int)(i >> 24) & 0xFF, (int)(i >> 16) & 0xFF, (int)(i >> 8) & 0xFF, (int)i & 0xFF) : new Color((int)(i >> 16) & 0xFF, (int)(i >> 8) & 0xFF, (int)i & 0xFF);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                Field field = Color.class.getField(color.toUpperCase().replaceAll(" ", "_"));
                if (field != null && Modifier.isStatic(field.getModifiers()) && Modifier.isPublic(field.getModifiers())) {
                    result = (Color)field.get(Color.class);
                }
            }
            catch (NoSuchFieldException ignored) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new YamlException("Invalid color: " + color);
        }
        return result;
    }
}

