/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.ho.yaml.CustomYamlConfig;
import org.json.JSONException;
import org.json.JSONWriter;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.config.HostMatcher;
import org.mapfish.print.config.Key;
import org.mapfish.print.config.LocalHostMatcher;
import org.mapfish.print.config.SecurityStrategy;
import org.mapfish.print.config.layout.Layout;
import org.mapfish.print.config.layout.Layouts;
import org.mapfish.print.map.MapTileTask;
import org.mapfish.print.map.readers.WMSServerInfo;
import org.mapfish.print.output.OutputFactory;
import org.pvalsecc.concurrent.OrderedResultsExecutor;

public class Config {
    public static final Logger LOGGER = Logger.getLogger(Config.class);
    private Layouts layouts;
    private TreeSet<Integer> dpis;
    private TreeSet<Integer> scales;
    private String maxSvgWidth = "";
    private String maxSvgHeight = "";
    private double maxSvgW = Double.MAX_VALUE;
    private double maxSvgH = Double.MAX_VALUE;
    private boolean reloadConfig = false;
    private boolean integerSvg = true;
    private List<String> overlayLayers = null;
    private TreeSet<String> fonts = null;
    private List<HostMatcher> hosts = new ArrayList<HostMatcher>();
    private HashMap localHostForward;
    private TreeSet<Key> keys;
    private int globalParallelFetches = 5;
    private int perHostParallelFetches = 5;
    private int socketTimeout = 2400000;
    private int connectionTimeout = 2400000;
    private boolean tilecacheMerging = false;
    private List<SecurityStrategy> security = Collections.emptyList();
    private String outputFilename = "mapfish-print.pdf";
    private static final double BEST_SCALE_TOLERANCE = 0.98;
    private OrderedResultsExecutor<MapTileTask> mapRenderingExecutor = null;
    private MultiThreadedHttpConnectionManager connectionManager;
    private TreeSet<String> formats;

    public Config() {
        this.hosts.add(new LocalHostMatcher());
    }

    public static Config fromYaml(File file) throws FileNotFoundException {
        CustomYamlConfig config = new CustomYamlConfig();
        Config result = (Config)config.loadType(file, Config.class);
        result.validate();
        return result;
    }

    public static Config fromInputStream(InputStream instream) {
        CustomYamlConfig config = new CustomYamlConfig();
        Config result = (Config)config.loadType(instream, Config.class);
        result.validate();
        return result;
    }

    public static Config fromString(String strConfig) {
        CustomYamlConfig config = new CustomYamlConfig();
        Config result = (Config)config.loadType(strConfig, Config.class);
        result.validate();
        return result;
    }

    public Layout getLayout(String name) {
        return (Layout)this.layouts.get(name);
    }

    public void setLayouts(Layouts layouts) {
        this.layouts = layouts;
    }

    public void setDpis(TreeSet<Integer> dpis) {
        this.dpis = dpis;
    }

    public void setMaxSvgWidth(String maxSvgWidth) {
        this.maxSvgWidth = maxSvgWidth;
        this.maxSvgW = Double.parseDouble(maxSvgWidth);
    }

    public String getMaxSvgWidth() {
        return this.maxSvgWidth;
    }

    public void setMaxSvgHeight(String maxSvgHeight) {
        this.maxSvgHeight = maxSvgHeight;
        this.maxSvgH = Double.parseDouble(maxSvgHeight);
    }

    public String getMaxSvgHeight() {
        return this.maxSvgHeight;
    }

    public double getMaxSvgW() {
        return this.maxSvgW;
    }

    public double getMaxSvgH() {
        return this.maxSvgH;
    }

    public TreeSet<Integer> getDpis() {
        return this.dpis;
    }

    public void printClientConfig(JSONWriter json) throws JSONException {
        json.key("scales");
        json.array();
        for (Integer scale : this.scales) {
            json.object();
            json.key("name").value((Object)("1:" + NumberFormat.getIntegerInstance().format(scale)));
            json.key("value").value((Object)scale.toString());
            json.endObject();
        }
        json.endArray();
        json.key("dpis");
        json.array();
        for (Integer dpi : this.dpis) {
            json.object();
            json.key("name").value((Object)dpi.toString());
            json.key("value").value((Object)dpi.toString());
            json.endObject();
        }
        json.endArray();
        json.key("outputFormats");
        json.array();
        for (String format : OutputFactory.getSupportedFormats(this)) {
            json.object();
            json.key("name").value((Object)format);
            json.endObject();
        }
        json.endArray();
        json.key("layouts");
        json.array();
        ArrayList sortedLayouts = new ArrayList();
        sortedLayouts.addAll(this.layouts.keySet());
        Collections.sort(sortedLayouts);
        for (int i = 0; i < sortedLayouts.size(); ++i) {
            String key = (String)sortedLayouts.get(i);
            json.object();
            json.key("name").value((Object)key);
            ((Layout)this.layouts.get(key)).printClientConfig(json);
            json.endObject();
        }
        json.endArray();
    }

    public void setScales(TreeSet<Integer> scales) {
        this.scales = scales;
    }

    public boolean isScalePresent(int scale) {
        return this.scales.contains(scale);
    }

    public void setHosts(List<HostMatcher> hosts) {
        this.hosts = hosts;
    }

    public void setFonts(TreeSet<String> fonts) {
        this.fonts = fonts;
    }

    public TreeSet<String> getFonts() {
        return this.fonts;
    }

    public void setKeys(TreeSet<Key> keys) {
        this.keys = keys;
    }

    public TreeSet<Key> getKeys() {
        TreeSet<Key> k = this.keys;
        if (k == null) {
            k = new TreeSet();
        }
        return k;
    }

    public boolean validateUri(URI uri) throws UnknownHostException, SocketException, MalformedURLException {
        for (int i = 0; i < this.hosts.size(); ++i) {
            HostMatcher matcher = this.hosts.get(i);
            if (!matcher.validate(uri)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("URI [" + uri + "] accepted by: " + matcher));
            }
            return true;
        }
        return false;
    }

    public void validate() {
        if (this.layouts == null) {
            throw new InvalidValueException("layouts", "null");
        }
        this.layouts.validate();
        if (this.dpis == null) {
            throw new InvalidValueException("dpis", "null");
        }
        if (this.dpis.size() < 1) {
            throw new InvalidValueException("dpis", "[]");
        }
        if (this.scales == null) {
            throw new InvalidValueException("scales", "null");
        }
        if (this.scales.size() < 1) {
            throw new InvalidValueException("scales", "[]");
        }
        if (this.hosts == null) {
            throw new InvalidValueException("hosts", "null");
        }
        if (this.hosts.size() < 1) {
            throw new InvalidValueException("hosts", "[]");
        }
        if (this.globalParallelFetches < 1) {
            throw new InvalidValueException("globalParallelFetches", this.globalParallelFetches);
        }
        if (this.perHostParallelFetches < 1) {
            throw new InvalidValueException("perHostParallelFetches", this.perHostParallelFetches);
        }
        if (this.socketTimeout < 0) {
            throw new InvalidValueException("socketTimeout", this.socketTimeout);
        }
        if (this.connectionTimeout < 0) {
            throw new InvalidValueException("connectionTimeout", this.connectionTimeout);
        }
        for (Key key : this.getKeys()) {
            key.validate();
        }
    }

    public int getBestScale(double target) {
        target *= 0.98;
        for (Integer scale : this.scales) {
            if (!((double)scale.intValue() >= target)) continue;
            return scale;
        }
        return this.scales.last();
    }

    public synchronized OrderedResultsExecutor<MapTileTask> getMapRenderingExecutor() {
        if (this.mapRenderingExecutor == null && this.globalParallelFetches > 1) {
            this.mapRenderingExecutor = new OrderedResultsExecutor(this.globalParallelFetches, "tilesReader");
            this.mapRenderingExecutor.start();
        }
        return this.mapRenderingExecutor;
    }

    public synchronized void stop() {
        WMSServerInfo.clearCache();
        if (this.mapRenderingExecutor != null) {
            this.mapRenderingExecutor.stop();
        }
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
    }

    public void setGlobalParallelFetches(int globalParallelFetches) {
        this.globalParallelFetches = globalParallelFetches;
    }

    public void setPerHostParallelFetches(int perHostParallelFetches) {
        this.perHostParallelFetches = perHostParallelFetches;
        System.getProperties().setProperty("http.maxConnections", Integer.toString(perHostParallelFetches));
    }

    public HttpClient getHttpClient(URI uri) {
        MultiThreadedHttpConnectionManager connectionManager = this.getConnectionManager();
        HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        Logger.getLogger(HttpMethodBase.class).setLevel(Level.ERROR);
        ProxySelector selector = ProxySelector.getDefault();
        List<Proxy> proxyList = selector.select(uri);
        Proxy proxy = proxyList.get(0);
        if (!proxy.equals(Proxy.NO_PROXY)) {
            InetSocketAddress socketAddress = (InetSocketAddress)proxy.address();
            String hostName = socketAddress.getHostName();
            int port = socketAddress.getPort();
            httpClient.getHostConfiguration().setProxy(hostName, port);
        }
        for (SecurityStrategy sec : this.security) {
            if (!sec.matches(uri)) continue;
            sec.configure(uri, httpClient);
            break;
        }
        return httpClient;
    }

    private synchronized MultiThreadedHttpConnectionManager getConnectionManager() {
        if (this.connectionManager == null) {
            this.connectionManager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams params = this.connectionManager.getParams();
            params.setDefaultMaxConnectionsPerHost(this.perHostParallelFetches);
            params.setMaxTotalConnections(this.globalParallelFetches);
            params.setSoTimeout(this.socketTimeout);
            params.setConnectionTimeout(this.connectionTimeout);
        }
        return this.connectionManager;
    }

    public void setTilecacheMerging(boolean tilecacheMerging) {
        this.tilecacheMerging = tilecacheMerging;
    }

    public boolean isTilecacheMerging() {
        return this.tilecacheMerging;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getOutputFilename(String layoutName) {
        Layout layout = (Layout)this.layouts.get(layoutName);
        String name = null;
        if (layout != null && (name = layout.getOutputFilename()) != null) {
            name = PDFUtils.getValueFromString(name);
        }
        return name == null ? this.outputFilename : name;
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    public TreeSet<String> getFormats() {
        if (this.formats == null) {
            return new TreeSet<String>();
        }
        return this.formats;
    }

    public void setFormats(TreeSet<String> formats) {
        this.formats = formats;
    }

    public void setOverlayLayers(List<String> overlayLayers) {
        this.overlayLayers = overlayLayers;
    }

    public List<String> getOverlayLayers() {
        return this.overlayLayers;
    }

    public boolean getIntegerSvg() {
        return this.integerSvg;
    }

    public void setIntegerSvg(boolean integerSvg) {
        this.integerSvg = integerSvg;
    }

    public boolean getReloadConfig() {
        return this.reloadConfig;
    }

    public void setReloadConfig(boolean reloadConfig) {
        this.reloadConfig = reloadConfig;
    }

    public void setSecurity(List<SecurityStrategy> security) {
        this.security = security;
    }

    public void setLocalHostForward(HashMap localHostForward) {
        this.localHostForward = localHostForward;
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }

    public boolean localHostForwardIsHttps2http() {
        Object https2http;
        if (this.localHostForward != null && (https2http = this.localHostForward.get("https2http")) != null && https2http instanceof Boolean) {
            return (Boolean)https2http;
        }
        return false;
    }

    public boolean localHostForwardIsFrom(String host) {
        Object from;
        if (this.localHostForward != null && (from = this.localHostForward.get("from")) != null && from instanceof List) {
            return ((List)from).indexOf(host) >= 0;
        }
        return false;
    }
}

