/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPTable;
import java.util.List;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFCustomBlocks;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.MapBlock;
import org.mapfish.print.config.layout.TableConfig;
import org.mapfish.print.utils.PJsonObject;

public class ColumnsBlock
extends Block {
    private List<Block> items;
    private int[] widths = null;
    private double absoluteX = Double.MIN_VALUE;
    private double absoluteY = Double.MIN_VALUE;
    private double width = Double.MIN_VALUE;
    private int nbColumns = Integer.MIN_VALUE;
    private TableConfig config = null;

    @Override
    public void render(final PJsonObject params, Block.PdfElement target, final RenderingContext context) throws DocumentException {
        if (this.isAbsolute()) {
            context.getCustomBlocks().addAbsoluteDrawer(new PDFCustomBlocks.AbsoluteDrawer(){

                @Override
                public void render(PdfContentByte dc) throws DocumentException {
                    PdfPTable table = PDFUtils.buildTable(ColumnsBlock.this.items, params, context, ColumnsBlock.this.nbColumns, ColumnsBlock.this.config);
                    if (table != null) {
                        table.setTotalWidth((float)ColumnsBlock.this.width);
                        table.setLockedWidth(true);
                        if (ColumnsBlock.this.widths != null) {
                            table.setWidths(ColumnsBlock.this.widths);
                        }
                        table.writeSelectedRows(0, -1, (float)ColumnsBlock.this.absoluteX, (float)ColumnsBlock.this.absoluteY, dc);
                    }
                }
            });
        } else {
            PdfPTable table = PDFUtils.buildTable(this.items, params, context, this.nbColumns, this.config);
            if (table != null) {
                if (this.widths != null) {
                    table.setWidths(this.widths);
                }
                table.setSpacingAfter((float)this.spacingAfter);
                target.add((Element)table);
            }
        }
    }

    public void setItems(List<Block> items) {
        this.items = items;
    }

    public void setWidths(int[] widths) {
        this.widths = widths;
    }

    public void setAbsoluteX(double absoluteX) {
        this.absoluteX = absoluteX;
    }

    public void setAbsoluteY(double absoluteY) {
        this.absoluteY = absoluteY;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setNbColumns(int nbColumns) {
        this.nbColumns = nbColumns;
    }

    @Override
    public boolean isAbsolute() {
        return this.absoluteX != Double.MIN_VALUE && this.absoluteY != Double.MIN_VALUE && this.width != Double.MIN_VALUE;
    }

    @Override
    public MapBlock getMap() {
        for (Block item : this.items) {
            MapBlock result = item.getMap();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void setConfig(TableConfig config) {
        this.config = config;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.items == null) {
            throw new InvalidValueException("items", "null");
        }
        if (this.items.size() < 1) {
            throw new InvalidValueException("items", "[]");
        }
        if (!(this.absoluteX != Double.MIN_VALUE && this.absoluteY != Double.MIN_VALUE && this.width != Double.MIN_VALUE || this.absoluteX == Double.MIN_VALUE && this.absoluteY == Double.MIN_VALUE && this.width == Double.MIN_VALUE)) {
            throw new InvalidValueException("absoluteX, absoluteY or width", "all of them must be defined or none");
        }
        for (int i = 0; i < this.items.size(); ++i) {
            Block item = this.items.get(i);
            item.validate();
            if (!item.isAbsolute()) continue;
            throw new InvalidValueException("items", "Cannot put an absolute block in a !columns or !table block");
        }
        if (this.config != null) {
            this.config.validate();
        }
    }
}

