/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.mapfish.print.ChunkDrawer;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFCustomBlocks;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.utils.PJsonObject;

public class ImageBlock
extends Block {
    private String url = null;
    private double maxWidth = 0.0;
    private double maxHeight = 0.0;
    private String rotation = "0";

    @Override
    public void render(PJsonObject params, Block.PdfElement target, RenderingContext context) throws DocumentException {
        URI url;
        try {
            String urlTxt = PDFUtils.evalString(context, params, this.url);
            url = new URI(urlTxt);
        }
        catch (URISyntaxException e) {
            throw new InvalidValueException("url", this.url, e);
        }
        if (url.getPath().endsWith(".svg")) {
            this.drawSVG(context, params, target, url);
        } else {
            target.add((Element)PDFUtils.createImageChunk(context, this.maxWidth, this.maxHeight, url, this.getRotationRadian(context, params)));
        }
    }

    private float getRotationRadian(RenderingContext context, PJsonObject params) {
        return (float)((double)Float.parseFloat(PDFUtils.evalString(context, params, this.rotation)) * Math.PI / 180.0);
    }

    private void drawSVG(RenderingContext context, PJsonObject params, Block.PdfElement paragraph, URI url) throws DocumentException {
        TranscoderInput ti = new TranscoderInput(url.toString());
        PrintTranscoder pt = new PrintTranscoder();
        pt.addTranscodingHint(PrintTranscoder.KEY_SCALE_TO_PAGE, (Object)Boolean.TRUE);
        pt.transcode(ti, null);
        Paper paper = new Paper();
        paper.setSize(this.maxWidth, this.maxHeight);
        paper.setImageableArea(0.0, 0.0, this.maxWidth, this.maxHeight);
        float rotation = this.getRotationRadian(context, params);
        PageFormat pf = new PageFormat();
        pf.setPaper(paper);
        SvgDrawer drawer = new SvgDrawer(context.getCustomBlocks(), rotation, pt, pf);
        paragraph.add((Element)PDFUtils.createPlaceholderTable(this.maxWidth, this.maxHeight, this.spacingAfter, drawer, this.align, context.getCustomBlocks()));
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMaxWidth(double maxWidth) {
        this.maxWidth = maxWidth;
        if (maxWidth < 0.0) {
            throw new InvalidValueException("maxWidth", maxWidth);
        }
    }

    public void setMaxHeight(double maxHeight) {
        this.maxHeight = maxHeight;
        if (maxHeight < 0.0) {
            throw new InvalidValueException("maxHeight", maxHeight);
        }
    }

    public void setRotation(String rotation) {
        this.rotation = rotation;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.url == null) {
            throw new InvalidValueException("url", "null");
        }
    }

    private class SvgDrawer
    extends ChunkDrawer {
        private final float rotation;
        private final PrintTranscoder pt;
        private final PageFormat pf;

        public SvgDrawer(PDFCustomBlocks customBlocks, float rotation, PrintTranscoder pt, PageFormat pf) {
            super(customBlocks);
            this.rotation = rotation;
            this.pt = pt;
            this.pf = pf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void renderImpl(Rectangle rectangle, PdfContentByte dc) {
            dc.saveState();
            Graphics g2 = null;
            try {
                AffineTransform t = AffineTransform.getTranslateInstance(rectangle.getLeft(), rectangle.getBottom());
                if (this.rotation != 0.0f) {
                    t.rotate(this.rotation, ImageBlock.this.maxWidth / 2.0, ImageBlock.this.maxHeight / 2.0);
                }
                dc.transform(t);
                g2 = dc.createGraphics((float)ImageBlock.this.maxWidth, (float)ImageBlock.this.maxHeight);
                System.setProperty("org.apache.batik.warn_destination", "false");
                ((Graphics2D)g2).setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, "Printing");
                ((Graphics2D)g2).setRenderingHint(RenderingHintsKeyExt.KEY_AVOID_TILE_PAINTING, RenderingHintsKeyExt.VALUE_AVOID_TILE_PAINTING_ON);
                this.pt.print(g2, this.pf, 0);
            }
            finally {
                if (g2 != null) {
                    g2.dispose();
                }
                dc.restoreState();
            }
        }
    }
}

