/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class LegendsBlock
extends Block {
    public static final Logger LOGGER = Logger.getLogger(LegendsBlock.class);
    private double maxHeight = 0.0;
    private double maxWidth = 0.0;
    private double maxIconWidth = 0.0;
    private double maxIconHeight = 8.0;
    private float scale = 0.0f;
    private boolean inline = true;
    private double classIndentation = 20.0;
    private float layerSpace = 5.0f;
    private float classSpace = 2.0f;
    private String layerFont = "Helvetica";
    protected double layerFontSize = 10.0;
    private String classFont = "Helvetica";
    protected double classFontSize = 8.0;
    private String fontEncoding = "Cp1252";
    private double columnMargin = 3.0;

    @Override
    public void render(PJsonObject params, Block.PdfElement target, RenderingContext context) throws DocumentException {
        Renderer renderer = new Renderer(params, context);
        renderer.render(target);
    }

    public void setMaxWidth(double maxWidth) {
        this.maxWidth = maxWidth;
        if (maxWidth < 0.0) {
            throw new InvalidValueException("maxWidth", maxWidth);
        }
    }

    public void setMaxHeight(double maxHeight) {
        this.maxHeight = maxHeight;
        if (maxHeight < 0.0) {
            throw new InvalidValueException("maxHeight", maxHeight);
        }
    }

    public void setDefaultScale(double scale) {
        this.scale = (float)scale;
        if (scale < 0.0) {
            throw new InvalidValueException("scale", scale);
        }
    }

    public void setInline(String inline) {
        this.inline = "true".equalsIgnoreCase(inline);
        if (!inline.equalsIgnoreCase("true") && !inline.equalsIgnoreCase("false")) {
            throw new InvalidValueException("inline", inline);
        }
    }

    public void setMaxIconWidth(double maxIconWidth) {
        this.maxIconWidth = maxIconWidth;
        if (maxIconWidth < 0.0) {
            throw new InvalidValueException("maxIconWidth", maxIconWidth);
        }
    }

    public void setMaxIconHeight(double maxIconHeight) {
        this.maxIconHeight = maxIconHeight;
        if (maxIconHeight < 0.0) {
            throw new InvalidValueException("maxIconHeight", maxIconHeight);
        }
    }

    public void setClassIndentation(double classIndentation) {
        this.classIndentation = classIndentation;
        if (classIndentation < 0.0) {
            throw new InvalidValueException("classIndentation", classIndentation);
        }
    }

    public void setClassFont(String classFont) {
        this.classFont = classFont;
    }

    public void setClassFontSize(double classFontSize) {
        this.classFontSize = classFontSize;
        if (classFontSize < 0.0) {
            throw new InvalidValueException("classFontSize", classFontSize);
        }
    }

    public String getClassFont() {
        return this.classFont;
    }

    protected Font getLayerPdfFont() {
        return FontFactory.getFont((String)this.layerFont, (String)this.fontEncoding, (float)((float)this.layerFontSize));
    }

    protected Font getClassPdfFont() {
        return FontFactory.getFont((String)this.classFont, (String)this.fontEncoding, (float)((float)this.classFontSize));
    }

    public void setLayerSpace(double layerSpace) {
        this.layerSpace = (float)layerSpace;
        if (layerSpace < 0.0) {
            throw new InvalidValueException("layerSpace", layerSpace);
        }
    }

    public void setClassSpace(double classSpace) {
        this.classSpace = (float)classSpace;
        if (classSpace < 0.0) {
            throw new InvalidValueException("classSpace", classSpace);
        }
    }

    public void setLayerFont(String layerFont) {
        this.layerFont = layerFont;
    }

    public void setLayerFontSize(double layerFontSize) {
        this.layerFontSize = layerFontSize;
        if (layerFontSize < 0.0) {
            throw new InvalidValueException("layerFontSize", layerFontSize);
        }
    }

    public void setFontEncoding(String fontEncoding) {
        this.fontEncoding = fontEncoding;
    }

    public void setColumnMargin(double columnMargin) {
        this.columnMargin = columnMargin;
    }

    private class Renderer {
        private PJsonObject params;
        private RenderingContext context;
        private ArrayList<PdfPTable> columns = new ArrayList();
        private ArrayList<Float> columnsWidth = new ArrayList();
        private float cellWidth = 0.0f;
        private PdfPTable column = new PdfPTable(1);
        private PdfPCell title;
        private double currentCellHeight = 0.0;
        private double currentColumnHeight = 0.0;

        public Renderer(PJsonObject params, RenderingContext context) {
            this.column.setWidthPercentage(100.0f);
            this.columns.add(this.column);
            this.currentCellHeight = 0.0;
            this.columnsWidth.add(Float.valueOf(0.0f));
            this.params = params;
            this.context = context;
        }

        public void render(Block.PdfElement target) throws DocumentException {
            Font layerPdfFont = LegendsBlock.this.getLayerPdfFont();
            Font classPdfFont = LegendsBlock.this.getClassPdfFont();
            PJsonArray legends = this.context.getGlobalParams().optJSONArray("legends");
            if (legends != null && legends.size() > 0) {
                for (int i = 0; i < legends.size(); ++i) {
                    PJsonObject layer = legends.getJSONObject(i);
                    this.createLine(0.0, layer, layerPdfFont, i == 0 ? 0.0f : LegendsBlock.this.layerSpace, true, true);
                    PJsonArray classes = layer.getJSONArray("classes");
                    for (int j = 0; j < classes.size(); ++j) {
                        PJsonObject clazz = classes.getJSONObject(j);
                        this.createLine(LegendsBlock.this.classIndentation, clazz, classPdfFont, LegendsBlock.this.classSpace, false, false);
                    }
                }
            }
            int index = this.columnsWidth.size() - 1;
            this.columnsWidth.set(index, Float.valueOf(Math.max(this.columnsWidth.get(index).floatValue(), this.cellWidth)));
            if (this.title != null) {
                this.column.addCell(this.title);
            }
            int len = this.columns.size();
            float fullWidth = 0.0f;
            for (int i = 0; i < len; ++i) {
                float width = this.columnsWidth.get(i).floatValue();
                if ((double)(fullWidth + width) < LegendsBlock.this.maxWidth) {
                    fullWidth = (float)((double)fullWidth + ((double)width + LegendsBlock.this.columnMargin));
                    continue;
                }
                len = i + 1;
            }
            float[] pdfWidths = new float[len + 1];
            for (int i = 0; i < len; ++i) {
                pdfWidths[i] = this.columnsWidth.get(i).floatValue();
            }
            pdfWidths[len] = Math.max(0.0f, (float)LegendsBlock.this.maxWidth - fullWidth);
            PdfPTable table = new PdfPTable(pdfWidths);
            table.setWidthPercentage(100.0f);
            table.getDefaultCell().setBorder(0);
            table.getDefaultCell().setPadding(0.0f);
            table.setSpacingAfter((float)LegendsBlock.this.spacingAfter);
            for (int i = 0; i < len; ++i) {
                table.addCell(this.columns.get(i));
            }
            table.addCell("");
            target.add((Element)table);
        }

        private void createLine(double indent, PJsonObject node, Font pdfFont, float lineSpace, boolean escapeOrphanTitle, boolean defaultIconBeforeName) throws DocumentException {
            String name = node.getString("name");
            String icon = node.optString("icon");
            PJsonArray icons = node.optJSONArray("icons");
            Paragraph result = new Paragraph();
            boolean iconBeforeName = node.optBool("iconBeforeName", defaultIconBeforeName);
            if (iconBeforeName) {
                result = this.addIconToParagraph(indent, lineSpace, icon, icons, result);
                this.addTitleSeparator(indent, lineSpace, result);
                this.addName(pdfFont, escapeOrphanTitle, name, result);
            } else {
                this.addName(pdfFont, escapeOrphanTitle, name, result);
                this.addCell(indent, lineSpace, result);
                result = new Paragraph();
                result = this.addIconToParagraph(indent, lineSpace, icon, icons, result);
                this.addTitleSeparator(indent, lineSpace, result);
            }
            if (!escapeOrphanTitle) {
                this.column.addCell(this.title);
                this.title = null;
            }
        }

        private void addName(Font pdfFont, boolean escapeOrphanTitle, String name, Paragraph result) {
            result.setFont(pdfFont);
            result.add((Object)name);
            if (name.trim().length() > 0) {
                float width;
                BaseFont baseFont = pdfFont.getBaseFont();
                float f = width = baseFont == null ? pdfFont.getSize() : baseFont.getWidthPoint(name, pdfFont.getSize());
                if (escapeOrphanTitle) {
                    this.currentCellHeight += (double)pdfFont.getSize();
                    this.cellWidth = Math.max(this.cellWidth, width);
                } else {
                    this.currentColumnHeight += (double)pdfFont.getSize();
                    int index = this.columnsWidth.size() - 1;
                    this.columnsWidth.set(index, Float.valueOf(Math.max(this.columnsWidth.get(index).floatValue(), width)));
                }
            }
            if (this.title != null && LegendsBlock.this.getBackgroundColorVal(this.context, this.params) != null) {
                this.title.setBackgroundColor(LegendsBlock.this.getBackgroundColorVal(this.context, this.params));
            }
        }

        private void addTitleSeparator(double indent, float lineSpace, Paragraph result) {
            if (this.title != null) {
                this.column.addCell(this.title);
            }
            this.title = new PdfPCell((Phrase)result);
            this.title.setBorder(0);
            this.title.setPadding(0.0f);
            this.title.setPaddingLeft((float)indent);
            if (LegendsBlock.this.inline) {
                this.title.setPaddingTop(lineSpace);
            }
        }

        private Paragraph addIconToParagraph(double indent, float lineSpace, String icon, PJsonArray icons, Paragraph result) throws DocumentException {
            if (icon != null) {
                result = this.createIcon(indent, lineSpace, icon, result);
            }
            if (icons != null) {
                for (int i = 0; i < icons.size(); ++i) {
                    String iconItem = icons.getString(i);
                    result = this.createIcon(indent, i == 0 ? lineSpace : 0.0f, iconItem, result);
                }
            }
            return result;
        }

        private Paragraph createIcon(double indent, float lineSpace, String icon, Paragraph result) throws DocumentException {
            try {
                Chunk iconChunk = null;
                iconChunk = icon.indexOf("image%2Fsvg%2Bxml") != -1 ? PDFUtils.createImageChunkFromSVG(this.context, icon, LegendsBlock.this.maxIconWidth, LegendsBlock.this.maxIconHeight) : PDFUtils.createImageChunk(this.context, LegendsBlock.this.maxIconWidth, LegendsBlock.this.maxIconHeight, LegendsBlock.this.scale, URI.create(icon), 0.0f);
                result.add((Object)iconChunk);
                if (!LegendsBlock.this.inline) {
                    this.currentCellHeight += (double)(iconChunk.getImage().getPlainHeight() + lineSpace);
                    this.cellWidth = Math.max(this.cellWidth, iconChunk.getImage().getPlainWidth());
                    this.addCell(indent, lineSpace, result);
                    result = new Paragraph();
                } else {
                    result.add((Object)" ");
                }
            }
            catch (IOException ioe) {
                LOGGER.warn((Object)("Failed to load " + icon + " with " + ioe.getMessage()));
            }
            catch (InvalidValueException e) {
                LOGGER.warn((Object)("Failed to create image chunk: " + e.getMessage()));
            }
            return result;
        }

        private void addCell(double indent, float lineSpace, Paragraph icon) {
            PdfPCell cell = new PdfPCell((Phrase)icon);
            cell.setBorder(0);
            cell.setPadding(0.0f);
            cell.setPaddingLeft((float)indent);
            if (LegendsBlock.this.getBackgroundColorVal(this.context, this.params) != null) {
                cell.setBackgroundColor(LegendsBlock.this.getBackgroundColorVal(this.context, this.params));
            }
            cell.setPaddingTop(lineSpace);
            this.currentCellHeight += (double)lineSpace;
            if (!LegendsBlock.this.inline && LegendsBlock.this.maxHeight != 0.0 && this.currentColumnHeight + this.currentCellHeight > LegendsBlock.this.maxHeight) {
                this.column = new PdfPTable(1);
                this.column.setWidthPercentage(100.0f);
                this.columns.add(this.column);
                this.currentColumnHeight = 0.0;
                this.columnsWidth.add(Float.valueOf(this.cellWidth));
            } else {
                int index = this.columnsWidth.size() - 1;
                this.columnsWidth.set(index, Float.valueOf(Math.max(this.columnsWidth.get(index).floatValue(), this.cellWidth)));
            }
            this.cellWidth = 0.0f;
            this.currentColumnHeight += this.currentCellHeight;
            this.currentCellHeight = 0.0;
            if (this.title != null) {
                this.column.addCell(this.title);
                this.title = null;
            }
            this.column.addCell(cell);
        }
    }
}

