/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import java.awt.geom.AffineTransform;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.MapTileTask;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class ImageMapReader
extends MapReader {
    private static final Log LOGGER = LogFactory.getLog(ImageMapReader.class);
    private final String name;
    private final RenderingContext context;
    private final URI baseUrl;
    private final float extentMinX;
    private final float extentMinY;
    private final float extentMaxX;
    private final float extentMaxY;

    protected ImageMapReader(RenderingContext context, PJsonObject params) {
        super(params);
        this.name = params.getString("name");
        this.context = context;
        try {
            this.baseUrl = new URI(params.getString("baseURL"));
        }
        catch (Exception e) {
            throw new InvalidJsonValueException(params, "baseURL", params.getString("baseURL"), e);
        }
        PJsonArray extent = params.getJSONArray("extent");
        this.extentMinX = extent.getFloat(0);
        this.extentMinY = extent.getFloat(1);
        this.extentMaxX = extent.getFloat(2);
        this.extentMaxY = extent.getFloat(3);
        this.checkSecurity(context, params);
    }

    private void checkSecurity(RenderingContext context, PJsonObject params) {
        try {
            if (!context.getConfig().validateUri(this.baseUrl)) {
                throw new InvalidJsonValueException(params, "baseURL", this.baseUrl);
            }
        }
        catch (Exception e) {
            throw new InvalidJsonValueException(params, "baseURL", this.baseUrl, e);
        }
    }

    @Override
    public void render(final Transformer transformer, ParallelMapTileLoader parallelMapTileLoader, String srs, boolean first) {
        LOGGER.debug((Object)this.baseUrl);
        parallelMapTileLoader.addTileToLoad(new MapTileTask(){
            public Image image;

            @Override
            public void readTile() throws DocumentException {
                this.image = PDFUtils.createImage(ImageMapReader.this.context, ImageMapReader.this.extentMaxX - ImageMapReader.this.extentMinX, ImageMapReader.this.extentMaxY - ImageMapReader.this.extentMinY, ImageMapReader.this.baseUrl, 0.0f);
                this.image.setAbsolutePosition(ImageMapReader.this.extentMinX, ImageMapReader.this.extentMinY);
            }

            @Override
            public void renderOnPdf(PdfContentByte dc) throws DocumentException {
                AffineTransform geoTransform = transformer.getGeoTransform(false);
                dc.transform(geoTransform);
                if ((double)ImageMapReader.this.opacity < 1.0) {
                    PdfGState gs = new PdfGState();
                    gs.setFillOpacity(ImageMapReader.this.opacity);
                    gs.setStrokeOpacity(ImageMapReader.this.opacity);
                    dc.setGState(gs);
                }
                dc.addImage(this.image);
            }
        });
    }

    @Override
    public boolean testMerge(MapReader other) {
        return false;
    }

    @Override
    protected boolean canMerge(MapReader other) {
        return false;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static void create(List<MapReader> target, RenderingContext context, PJsonObject params) {
        target.add(new ImageMapReader(context, params));
    }
}

