/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.util.List;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.ImageMapReader;
import org.mapfish.print.map.readers.KaMapCacheMapReader;
import org.mapfish.print.map.readers.KaMapMapReader;
import org.mapfish.print.map.readers.MapServerMapReader;
import org.mapfish.print.map.readers.OsmMapReader;
import org.mapfish.print.map.readers.TileCacheMapReader;
import org.mapfish.print.map.readers.TmsMapReader;
import org.mapfish.print.map.readers.VectorMapReader;
import org.mapfish.print.map.readers.WMSMapReader;
import org.mapfish.print.map.readers.WMTSMapReader;
import org.mapfish.print.map.readers.google.GoogleMapReader;
import org.mapfish.print.map.readers.google.GoogleMapTileReader;
import org.mapfish.print.utils.PJsonObject;

public abstract class MapReader {
    protected final float opacity;

    public MapReader(PJsonObject params) {
        this.opacity = params.optFloat("opacity", 1.0f).floatValue();
    }

    public abstract void render(Transformer var1, ParallelMapTileLoader var2, String var3, boolean var4);

    public static void create(List<MapReader> target, String type, RenderingContext context, PJsonObject params) {
        if ("WMS".equalsIgnoreCase(type)) {
            WMSMapReader.create(target, context, params);
        } else if ("MapServer".equalsIgnoreCase(type)) {
            MapServerMapReader.create(target, context, params);
        } else if ("TileCache".equalsIgnoreCase(type)) {
            TileCacheMapReader.create(target, context, params);
        } else if ("Osm".equalsIgnoreCase(type)) {
            OsmMapReader.create(target, context, params);
        } else if ("Tms".equalsIgnoreCase(type)) {
            TmsMapReader.create(target, context, params);
        } else if ("Vector".equalsIgnoreCase(type)) {
            VectorMapReader.create(target, context, params);
        } else if ("Image".equalsIgnoreCase(type)) {
            ImageMapReader.create(target, context, params);
        } else if ("TiledGoogle".equalsIgnoreCase(type)) {
            GoogleMapTileReader.create(target, context, params);
        } else if ("Google".equalsIgnoreCase(type)) {
            GoogleMapReader.create(target, context, params);
        } else if ("KaMapCache".equalsIgnoreCase(type)) {
            KaMapCacheMapReader.create(target, context, params);
        } else if ("KaMap".equalsIgnoreCase(type)) {
            KaMapMapReader.create(target, context, params);
        } else if ("WMTS".equalsIgnoreCase(type)) {
            WMTSMapReader.create(target, context, params);
        } else {
            throw new InvalidJsonValueException(params, "type", type);
        }
    }

    public abstract boolean testMerge(MapReader var1);

    protected boolean canMerge(MapReader other) {
        return this.opacity == other.opacity;
    }

    public abstract String toString();
}

