/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.readers.TileCacheLayerInfo;
import org.mapfish.print.map.readers.TileableMapReader;
import org.mapfish.print.map.readers.TmsLayerInfo;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class TmsMapReader
extends TileableMapReader {
    protected final String layer;
    private final String format;
    private final String extension;
    private final String layerName;
    private final String serviceVersion;

    protected TmsMapReader(String layer, RenderingContext context, PJsonObject params) {
        super(context, params);
        this.layer = layer;
        PJsonArray maxExtent = params.getJSONArray("maxExtent");
        PJsonArray tileSize = params.getJSONArray("tileSize");
        this.format = params.getString("format");
        this.serviceVersion = "1.0.0";
        int formatSemicolon = this.format.indexOf(";");
        this.extension = formatSemicolon > 0 ? this.format.substring(0, formatSemicolon).trim() : this.format.trim();
        this.layerName = params.getString("layer");
        this.tileCacheLayerInfo = new TmsLayerInfo(params.getJSONArray("resolutions"), tileSize.getInt(0), tileSize.getInt(1), maxExtent.getFloat(0), maxExtent.getFloat(1), maxExtent.getFloat(2), maxExtent.getFloat(3), this.extension);
    }

    @Override
    protected TileRenderer.Format getFormat() {
        return TileRenderer.Format.BITMAP;
    }

    @Override
    protected void addCommonQueryParams(Map<String, List<String>> result, Transformer transformer, String srs, boolean first) {
    }

    @Override
    protected URI getTileUri(URI commonUri, Transformer transformer, float minGeoX, float minGeoY, float maxGeoX, float maxGeoY, long w, long h) throws URISyntaxException, UnsupportedEncodingException {
        float targetResolution = (maxGeoX - minGeoX) / (float)w;
        TileCacheLayerInfo.ResolutionInfo resolution = this.tileCacheLayerInfo.getNearestResolution(targetResolution);
        int tileX = Math.round((minGeoX - this.tileCacheLayerInfo.getMinX()) / (resolution.value * (float)w));
        int tileY = Math.round((minGeoY - this.tileCacheLayerInfo.getMinY()) / (resolution.value * (float)h));
        StringBuilder path = new StringBuilder();
        if (!commonUri.getPath().endsWith("/")) {
            path.append('/');
        }
        path.append(this.serviceVersion);
        path.append('/').append(this.layerName);
        path.append('/').append(String.format("%02d", resolution.index));
        path.append('/').append(tileX);
        path.append('/').append(tileY);
        path.append('.').append(this.format);
        return new URI(commonUri.getScheme(), commonUri.getUserInfo(), commonUri.getHost(), commonUri.getPort(), commonUri.getPath() + path, commonUri.getQuery(), commonUri.getFragment());
    }

    protected static void create(List<MapReader> target, RenderingContext context, PJsonObject params) {
        target.add(new TmsMapReader("t", context, params));
    }

    @Override
    public boolean testMerge(MapReader other) {
        return false;
    }

    @Override
    public boolean canMerge(MapReader other) {
        return false;
    }

    @Override
    public String toString() {
        return this.layer;
    }
}

