/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.readers.TileableMapReader;
import org.mapfish.print.map.readers.WMSServerInfo;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;
import org.pvalsecc.misc.StringUtils;
import org.pvalsecc.misc.URIUtils;

public class WMSMapReader
extends TileableMapReader {
    public static final Logger LOGGER = Logger.getLogger(WMSMapReader.class);
    private final String format;
    protected final List<String> layers = new ArrayList<String>();
    private final List<String> styles = new ArrayList<String>();

    private WMSMapReader(String layer, String style, RenderingContext context, PJsonObject params) {
        super(context, params);
        this.layers.add(layer);
        this.tileCacheLayerInfo = WMSServerInfo.getInfo(this.baseUrl, context).getTileCacheLayer(layer);
        this.styles.add(style);
        this.format = params.getString("format");
    }

    @Override
    protected TileRenderer.Format getFormat() {
        if (this.format.equals("image/svg+xml")) {
            return TileRenderer.Format.SVG;
        }
        if (this.format.equals("application/pdf") || this.format.equals("application/x-pdf")) {
            return TileRenderer.Format.PDF;
        }
        return TileRenderer.Format.BITMAP;
    }

    @Override
    public void render(Transformer transformer, ParallelMapTileLoader parallelMapTileLoader, String srs, boolean first) {
        PJsonObject customParams = this.params.optJSONObject("customParams");
        double oldAngle = transformer.getRotation();
        if (customParams != null && customParams.optString("angle") != null) {
            transformer.setRotation(0.0);
        }
        if (this.params.optBool("useNativeAngle", false)) {
            String angle = String.valueOf(-Math.toDegrees(transformer.getRotation()));
            try {
                if (customParams != null) {
                    customParams.getInternalObj().put("angle", (Object)angle);
                    customParams.getInternalObj().put("map_angle", (Object)angle);
                } else {
                    HashMap<String, String> customMap = new HashMap<String, String>();
                    customMap.put("angle", angle);
                    customMap.put("map_angle", angle);
                    this.params.getInternalObj().put("customParams", customMap);
                }
                transformer.setRotation(0.0);
            }
            catch (JSONException e) {
                LOGGER.error((Object)("Unable to set angle: " + ((Object)((Object)e)).getClass().getName() + " - " + e.getMessage()));
            }
        }
        super.render(transformer, parallelMapTileLoader, srs, first);
        transformer.setRotation(oldAngle);
    }

    @Override
    protected void addCommonQueryParams(Map<String, List<String>> result, Transformer transformer, String srs, boolean first) {
        URIUtils.addParamOverride(result, "FORMAT", this.format);
        URIUtils.addParamOverride(result, "LAYERS", StringUtils.join(this.layers, ","));
        URIUtils.addParamOverride(result, "SRS", srs);
        URIUtils.addParamOverride(result, "SERVICE", "WMS");
        URIUtils.addParamOverride(result, "REQUEST", "GetMap");
        URIUtils.addParamOverride(result, "VERSION", "1.1.1");
        if (!first) {
            URIUtils.addParamOverride(result, "TRANSPARENT", "true");
        }
        URIUtils.addParamOverride(result, "STYLES", StringUtils.join(this.styles, ","));
        URIUtils.addParamOverride(result, "format_options", "dpi:" + transformer.getDpi());
        URIUtils.addParamOverride(result, "map_resolution", String.valueOf(transformer.getDpi()));
    }

    protected static void create(List<MapReader> target, RenderingContext context, PJsonObject params) {
        PJsonArray layers = params.getJSONArray("layers");
        PJsonArray styles = params.optJSONArray("styles");
        for (int i = 0; i < layers.size(); ++i) {
            String layer = layers.getString(i);
            String style = "";
            if (styles != null && i < styles.size()) {
                style = styles.getString(i);
            }
            target.add(new WMSMapReader(layer, style, context, params));
        }
    }

    @Override
    public boolean testMerge(MapReader other) {
        if (this.canMerge(other)) {
            WMSMapReader wms = (WMSMapReader)other;
            this.layers.addAll(wms.layers);
            this.styles.addAll(wms.styles);
            return true;
        }
        return false;
    }

    @Override
    public boolean canMerge(MapReader other) {
        if (!super.canMerge(other)) {
            return false;
        }
        if (this.tileCacheLayerInfo != null && !this.context.getConfig().isTilecacheMerging()) {
            return false;
        }
        if (other instanceof WMSMapReader) {
            WMSMapReader wms = (WMSMapReader)other;
            if (!this.format.equals(wms.format)) {
                return false;
            }
            if (this.tileCacheLayerInfo != null && wms.tileCacheLayerInfo != null) {
                if (!this.tileCacheLayerInfo.equals(wms.tileCacheLayerInfo)) {
                    return false;
                }
            } else if (this.tileCacheLayerInfo == null != (wms.tileCacheLayerInfo == null)) {
                LOGGER.warn((Object)("Between [" + this + "] and [" + wms + "], one has a tilecache config and not the other"));
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected URI getTileUri(URI commonUri, Transformer transformer, float minGeoX, float minGeoY, float maxGeoX, float maxGeoY, long w, long h) throws URISyntaxException, UnsupportedEncodingException {
        HashMap<String, List<String>> tileParams = new HashMap<String, List<String>>();
        if (this.format.equals("image/svg+xml")) {
            double maxW = this.context.getConfig().getMaxSvgW();
            double maxH = this.context.getConfig().getMaxSvgH();
            double divisor = 1.0;
            double width = transformer.getRotatedSvgW();
            double height = transformer.getRotatedSvgH();
            if (maxW < width || maxH < height) {
                if (maxW / maxH < width / height) {
                    divisor = width / maxW;
                    width = maxW;
                    height /= divisor;
                } else {
                    divisor = height / maxH;
                    height = maxH;
                    width /= divisor;
                }
            }
            URIUtils.addParamOverride(tileParams, "WIDTH", Long.toString(Math.round(width)));
            URIUtils.addParamOverride(tileParams, "HEIGHT", Long.toString(Math.round(height)));
        } else {
            URIUtils.addParamOverride(tileParams, "WIDTH", Long.toString(w));
            URIUtils.addParamOverride(tileParams, "HEIGHT", Long.toString(h));
        }
        URIUtils.addParamOverride(tileParams, "BBOX", String.format("%s,%s,%s,%s", Float.valueOf(minGeoX), Float.valueOf(minGeoY), Float.valueOf(maxGeoX), Float.valueOf(maxGeoY)));
        return URIUtils.addParams(commonUri, tileParams, OVERRIDE_ALL);
    }

    @Override
    public String toString() {
        return StringUtils.join(this.layers, ", ");
    }
}

