/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.renderers.vector;

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.geom.AffineTransform;
import org.apache.log4j.Logger;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.ColorWrapper;
import org.mapfish.print.map.renderers.vector.GeometriesRenderer;
import org.mapfish.print.utils.PJsonObject;

public class LabelRenderer {
    public static final Logger LOGGER = Logger.getLogger(LabelRenderer.class);

    static void applyStyle(RenderingContext context, PdfContentByte dc, PJsonObject style, Geometry geometry, AffineTransform affineTransform) {
        String label = style.optString("label");
        if (label != null && label.length() > 0) {
            String labelAlign = style.optString("labelAlign", "cm");
            float labelXOffset = style.optFloat("labelXOffset", 0.0f).floatValue();
            float labelYOffset = style.optFloat("labelYOffset", 0.0f).floatValue();
            String fontColor = style.optString("fontColor", "#000000");
            String fontFamily = style.optString("fontFamily", "HELVETICA");
            if (!("COURIER".equalsIgnoreCase(fontFamily) && "HELVETICA".equalsIgnoreCase(fontFamily) && "TIMES_ROMAN".equalsIgnoreCase(fontFamily))) {
                LOGGER.info((Object)("Font: '" + fontFamily + "' not supported, supported fonts are 'HELVETICA', " + "'COURIER', 'TIMES_ROMAN', defaults to 'HELVETICA'"));
                fontFamily = "HELVETICA";
            }
            String fontSize = style.optString("fontSize", "12");
            String fontWeight = style.optString("fontWeight", "normal");
            Coordinate center = geometry.getCentroid().getCoordinate();
            center = GeometriesRenderer.transformCoordinate(center, affineTransform);
            float f = context.getStyleFactor();
            BaseFont bf = PDFUtils.getBaseFont(fontFamily, fontSize, fontWeight);
            float fontHeight = (float)Double.parseDouble(fontSize.toLowerCase().replaceAll("px", "")) * f;
            dc.setFontAndSize(bf, fontHeight);
            dc.setColorFill(ColorWrapper.convertColor(fontColor));
            dc.beginText();
            dc.setTextMatrix((float)center.x + labelXOffset * f, (float)center.y + labelYOffset * f);
            dc.showTextAligned(PDFUtils.getHorizontalAlignment(labelAlign), label, (float)center.x + labelXOffset * f, (float)center.y + labelYOffset * f - PDFUtils.getVerticalOffset(labelAlign, fontHeight), 0.0f);
            dc.endText();
        }
    }
}

