/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import org.mapfish.print.RenderingContext;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

abstract class AbstractImageFormat
implements OutputFormat {
    protected static final float MARGIN = 20.0f;
    protected final String format;

    protected AbstractImageFormat(String format) {
        this.format = format;
    }

    @Override
    public String contentType() {
        return "image/" + this.format;
    }

    @Override
    public String fileSuffix() {
        return this.format;
    }

    protected int calculateDPI(RenderingContext context, PJsonObject jsonSpec) {
        int MISSING_VALUE = -1;
        int dpi = jsonSpec.optInt("dpi", -1);
        dpi = Math.max(dpi, context.getGlobalParams().optInt("dpi", -1));
        PJsonArray pages = jsonSpec.optJSONArray("pages");
        if (pages != null) {
            for (int i = 0; i < pages.size(); ++i) {
                PJsonObject page = pages.getJSONObject(i);
                dpi = Math.max(dpi, page.optInt("dpi", -1));
            }
        }
        if (dpi < 0) {
            throw new IllegalArgumentException("unable to calculation DPI of maps");
        }
        return dpi;
    }
}

