/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import com.lowagie.text.DocumentException;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.operator.MosaicDescriptor;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.TimeLogger;
import org.mapfish.print.output.AbstractImageFormat;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.output.OutputFormatFactory;
import org.mapfish.print.utils.PJsonObject;

public class ImageOutputFactory
implements OutputFormatFactory {
    @Override
    public List<String> formats() {
        try {
            String[] formats = ImageIO.getWriterFormatNames();
            return Arrays.asList(formats);
        }
        catch (Throwable t) {
            return new ArrayList<String>();
        }
    }

    @Override
    public OutputFormat create(String format) {
        return new ImageOutput(format);
    }

    @Override
    public String enablementStatus() {
        try {
            MosaicDescriptor.class.getSimpleName();
        }
        catch (Throwable e) {
            return "JAI required";
        }
        try {
            MosaicDescriptor.class.getSimpleName();
        }
        catch (Throwable e) {
            return "JAI MosaicDescriptor not available on classpath";
        }
        return null;
    }

    public static class ImageOutput
    extends AbstractImageFormat {
        public static final Logger LOGGER = Logger.getLogger(ImageOutput.class);

        public ImageOutput(String format) {
            super(format);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RenderingContext print(MapPrinter printer, PJsonObject jsonSpec, OutputStream out, String referer) throws DocumentException {
            File tmpFile = null;
            try {
                RenderingContext context;
                TimeLogger timeLog;
                tmpFile = File.createTempFile("mapfishprint", ".pdf");
                FileOutputStream tmpOut = new FileOutputStream(tmpFile);
                try {
                    timeLog = TimeLogger.info(LOGGER, "PDF Creation");
                    context = printer.print(jsonSpec, tmpOut, referer);
                    timeLog.done();
                }
                finally {
                    tmpOut.close();
                }
                timeLog = TimeLogger.info(LOGGER, "Pdf to image conversion");
                List<BufferedImage> images = this.createImages(jsonSpec, tmpFile, context);
                timeLog.done();
                timeLog = TimeLogger.info(LOGGER, "Write Image");
                this.drawImage(out, images);
                timeLog.done();
                RenderingContext renderingContext = context;
                return renderingContext;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (tmpFile != null) {
                    if (!tmpFile.delete()) {
                        LOGGER.warn((Object)(tmpFile + " was not able to be deleted for unknown reason.  Will try again on shutdown"));
                    }
                    tmpFile.deleteOnExit();
                }
            }
        }

        private void drawImage(OutputStream out, List<? extends RenderedImage> images) throws IOException {
            ParameterBlock pbMosaic = new ParameterBlock();
            float height = 0.0f;
            float width = 0.0f;
            int i = 0;
            for (RenderedImage renderedImage : images) {
                LOGGER.debug((Object)("Adding page image " + ++i + " bounds: [" + 0 + "," + height + " " + renderedImage.getWidth() + "," + (height + (float)renderedImage.getHeight()) + "]"));
                ParameterBlock pbTranslate = new ParameterBlock();
                pbTranslate.addSource(renderedImage);
                pbTranslate.add(0.0f);
                pbTranslate.add(height);
                RenderedOp translated = JAI.create((String)"translate", (ParameterBlock)pbTranslate);
                pbMosaic.addSource(translated);
                height += (float)renderedImage.getHeight() + 20.0f;
                if (!(width < (float)renderedImage.getWidth())) continue;
                width = renderedImage.getWidth();
            }
            TileCache cache = JAI.createTileCache((long)((long)(height * width * 400.0f)));
            RenderingHints renderingHints = new RenderingHints(JAI.KEY_TILE_CACHE, cache);
            RenderedOp mosaic = JAI.create((String)"mosaic", (ParameterBlock)pbMosaic, (RenderingHints)renderingHints);
            ImageIO.write((RenderedImage)mosaic, "TIFF", out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<BufferedImage> createImages(PJsonObject jsonSpec, File tmpFile, RenderingContext context) throws IOException {
            ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
            PDDocument pdf = PDDocument.load((File)tmpFile);
            try {
                List pages = pdf.getDocumentCatalog().getAllPages();
                for (PDPage page : pages) {
                    BufferedImage img = page.convertToImage(6, this.calculateDPI(context, jsonSpec));
                    images.add(img);
                }
            }
            finally {
                pdf.close();
            }
            return images;
        }
    }
}

