/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.mapfish.print.config.Config;
import org.mapfish.print.output.ImageOutputFactory;
import org.mapfish.print.output.ImageOutputImageMagickFactory;
import org.mapfish.print.output.ImageOutputScalableFactory;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.output.OutputFormatFactory;
import org.mapfish.print.output.PdfOutput;
import org.mapfish.print.utils.PJsonObject;

public class OutputFactory {
    private static final Logger LOGGER = Logger.getLogger(OutputFactory.class);
    private static final List<OutputFormatFactory> formats = new ArrayList<OutputFormatFactory>();

    public static OutputFormat create(Config config, PJsonObject spec) {
        String id = spec.optString("outputFormat", "pdf");
        for (OutputFormatFactory formatFactory : formats) {
            String enablementMsg = formatFactory.enablementStatus();
            if (enablementMsg == null) {
                for (String supportedFormat : formatFactory.formats()) {
                    if (!OutputFactory.permitted(supportedFormat, config) || !supportedFormat.equalsIgnoreCase(id)) continue;
                    OutputFormat outputFormat = formatFactory.create(id);
                    LOGGER.info((Object)("OutputFormat chosen for " + id + " is " + outputFormat.getClass().getSimpleName()));
                    return outputFormat;
                }
                continue;
            }
            LOGGER.warn((Object)("OutputFormatFactory " + formatFactory.getClass().getSimpleName() + " is disabled: " + enablementMsg));
        }
        if (id.equalsIgnoreCase("pdf")) {
            throw new Error("There must be a format that can output PDF");
        }
        StringBuilder allFormats = new StringBuilder();
        for (String format : OutputFactory.getSupportedFormats(config)) {
            if (allFormats.length() > 0) {
                allFormats.append(", ");
            }
            allFormats.append(format.toLowerCase());
        }
        throw new IllegalArgumentException(id + " is not a supported format. Supported formats: " + allFormats);
    }

    public static Set<String> getSupportedFormats(Config config) {
        HashSet<String> supported = new HashSet<String>();
        for (OutputFormatFactory formatFactory : formats) {
            if (formatFactory.enablementStatus() != null) continue;
            for (String format : formatFactory.formats()) {
                if (!OutputFactory.permitted(format, config)) continue;
                supported.add(format.toLowerCase());
            }
        }
        return supported;
    }

    private static boolean permitted(String supportedFormat, Config config) {
        TreeSet<String> configuredFormats = config.getFormats();
        if (configuredFormats.size() == 1 && configuredFormats.iterator().next().trim().equals("*")) {
            return true;
        }
        if (configuredFormats.isEmpty()) {
            return "pdf".equalsIgnoreCase(supportedFormat);
        }
        for (String configuredFormat : configuredFormats) {
            if (!configuredFormat.equalsIgnoreCase(supportedFormat)) continue;
            return true;
        }
        return false;
    }

    static {
        formats.add(new PdfOutput());
        String useImageMagik = System.getProperties().getProperty("USE_IMAGEMAGICK");
        if (useImageMagik != null && "true".equals(useImageMagik.toLowerCase())) {
            formats.add(new ImageOutputImageMagickFactory());
        }
        formats.add(new ImageOutputScalableFactory());
        formats.add(new ImageOutputFactory());
    }
}

