/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import com.lowagie.text.DocumentException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.TimeLogger;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.output.OutputFormatFactory;
import org.mapfish.print.utils.PJsonObject;

public class PdfOutput
implements OutputFormat,
OutputFormatFactory {
    @Override
    public String contentType() {
        return "application/pdf";
    }

    @Override
    public String fileSuffix() {
        return "pdf";
    }

    @Override
    public List<String> formats() {
        return Collections.singletonList("pdf");
    }

    @Override
    public String enablementStatus() {
        return null;
    }

    @Override
    public OutputFormat create(String format) {
        return this;
    }

    @Override
    public RenderingContext print(MapPrinter printer, PJsonObject jsonSpec, OutputStream out, String referer) throws DocumentException {
        TimeLogger timeLog = TimeLogger.info(Logger.getLogger(PdfOutput.class), "PDF Creation");
        RenderingContext context = printer.print(jsonSpec, out, referer);
        timeLog.done();
        return context;
    }
}

