/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.comm;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.pvalsecc.comm.ObjectServerConnection;

public class ObjectClientConnection<OUT> {
    protected SocketChannel socket;

    public ObjectClientConnection(InetSocketAddress address) throws IOException {
        this.socket = SocketChannel.open(address);
    }

    protected void sendRequest(OUT request) throws IOException {
        ByteBuffer writeBuffer = ObjectServerConnection.marshall(request);
        writeBuffer.flip();
        while (writeBuffer.hasRemaining()) {
            this.socket.write(writeBuffer);
        }
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.socket.socket().getRemoteSocketAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.socket.socket().getLocalSocketAddress();
    }
}

