/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.comm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import org.pvalsecc.comm.ServerConnection;
import org.pvalsecc.misc.SystemUtilities;

public abstract class ObjectServerConnection<IN>
extends ServerConnection {
    private int length = 0;
    private ByteBuffer message = null;

    public ObjectServerConnection(SelectionKey key) {
        super(key);
    }

    @Override
    protected final void received(ByteBuffer buffer) {
        if (this.message == null) {
            this.length = buffer.getInt();
            if (buffer.remaining() >= this.length) {
                this.process(buffer);
                this.length = 0;
            } else {
                this.message = ByteBuffer.allocate(this.length);
                this.message.put(buffer.array(), buffer.position(), buffer.remaining());
            }
        } else {
            this.message.put(buffer.array(), buffer.position(), buffer.remaining());
            if (this.message.remaining() == 0) {
                this.message.flip();
                this.process(this.message);
                this.length = 0;
                this.message = null;
            }
        }
    }

    private void process(ByteBuffer buffer) {
        try {
            Object object = ObjectServerConnection.unmarshall(buffer, buffer.remaining());
            this.received(object);
        }
        catch (IOException e) {
            this.error("Cannot unmarshall the message", e);
        }
        catch (ClassNotFoundException e) {
            this.error("Cannot unmarshall the message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unmarshall(ByteBuffer buffer, int length) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream objectInputStream = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer.array(), buffer.position(), length);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            int availableBefore = byteArrayInputStream.available();
            Object result = objectInputStream.readObject();
            int availableAfter = byteArrayInputStream.available();
            buffer.position(buffer.position() + availableBefore - availableAfter);
            object = result;
        }
        catch (Throwable throwable) {
            SystemUtilities.safeClose(objectInputStream);
            throw throwable;
        }
        SystemUtilities.safeClose(objectInputStream);
        return object;
    }

    protected abstract void received(IN var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer marshall(Object object) throws IOException {
        ByteBuffer byteBuffer;
        ObjectOutputStream objectOutputStream = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteStream);
            objectOutputStream.writeObject(object);
            byte[] bytes = byteStream.toByteArray();
            ByteBuffer result = ByteBuffer.allocate(bytes.length + 4);
            result.putInt(bytes.length);
            result.put(bytes);
            byteBuffer = result;
        }
        catch (Throwable throwable) {
            SystemUtilities.safeClose(objectOutputStream);
            throw throwable;
        }
        SystemUtilities.safeClose(objectOutputStream);
        return byteBuffer;
    }
}

