/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.comm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import org.pvalsecc.comm.ObjectServerConnection;

public abstract class ObjectStreamServerConnection<IN>
extends ObjectServerConnection<IN> {
    private static final int MIN_SIZE = 0x100000;
    private Iterator<byte[]> iterator = null;
    private final ByteBuffer sizeMarshaller = ByteBuffer.allocate(4);
    private final MyByteArrayOutputStream byteStream = new MyByteArrayOutputStream(0x119999);

    public ObjectStreamServerConnection(SelectionKey key) {
        super(key);
    }

    public void answer(Iterator<byte[]> iterator) throws IOException {
        if (this.iterator != null) {
            throw new RuntimeException("cannot send an answer while an answer is pending");
        }
        this.iterator = iterator;
        this.scheduleNextPacket();
    }

    @Override
    protected boolean hasSomeMoreDataToSend() throws IOException {
        if (super.hasSomeMoreDataToSend()) {
            return true;
        }
        return this.scheduleNextPacket();
    }

    private boolean scheduleNextPacket() throws IOException {
        if (this.iterator.hasNext()) {
            while (this.iterator.hasNext() && this.byteStream.size() < 0x100000) {
                byte[] out = this.iterator.next();
                this.sizeMarshaller.rewind();
                this.sizeMarshaller.putInt(out.length);
                this.byteStream.write(this.sizeMarshaller.array());
                this.byteStream.write(out);
            }
            this.byteStream.flush();
            this.sendBunch(!this.iterator.hasNext());
            this.byteStream.reset();
            return true;
        }
        this.iterator = null;
        return false;
    }

    private void sendBunch(boolean addTerminator) {
        ByteBuffer result = ByteBuffer.allocate(this.byteStream.size() + (addTerminator ? 4 : 0));
        result.put(this.byteStream.getInternalBuffer(), 0, this.byteStream.size());
        if (addTerminator) {
            result.putInt(0);
        }
        result.flip();
        this.answer(result);
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        public MyByteArrayOutputStream(int size) {
            super(size);
        }

        public byte[] getInternalBuffer() {
            return this.buf;
        }
    }
}

