/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.comm;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ServerConnection {
    public static final Log LOGGER = LogFactory.getLog(ServerConnection.class);
    private final SelectionKey key;
    private final Queue<ByteBuffer> toSend = new LinkedList<ByteBuffer>();

    public ServerConnection(SelectionKey key) {
        this.key = key;
    }

    protected abstract void received(ByteBuffer var1);

    protected synchronized void answer(ByteBuffer buffer) {
        this.toSend.add(buffer);
        this.key.interestOps(5);
        this.key.selector().wakeup();
    }

    public synchronized int send(SocketChannel socket) throws IOException {
        ByteBuffer buffer = this.toSend.peek();
        int bytesSent = socket.write(buffer);
        if (!buffer.hasRemaining()) {
            this.toSend.remove();
            if (!this.hasSomeMoreDataToSend()) {
                this.key.interestOps(1);
            }
        }
        return bytesSent;
    }

    protected boolean hasSomeMoreDataToSend() throws IOException {
        return !this.toSend.isEmpty();
    }

    protected abstract void closed();

    protected void error(String message, Exception e) {
        LOGGER.error((Object)("[" + this.getChannelName() + "] " + message + " [" + this.toString() + "]"), (Throwable)e);
        try {
            this.close();
        }
        catch (IOException e1) {
            LOGGER.error((Object)"Trouble closing the connection after an error", (Throwable)e1);
        }
    }

    protected abstract String getChannelName();

    public SelectionKey getKey() {
        return this.key;
    }

    public String toString() {
        return this.getSocket().toString();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.getClientAddress().hashCode();
    }

    private Socket getSocket() {
        SocketChannel channel = (SocketChannel)this.key.channel();
        return channel.socket();
    }

    protected void close() throws IOException {
        this.key.channel().close();
        this.key.cancel();
    }

    public InetSocketAddress getClientAddress() {
        return (InetSocketAddress)this.getSocket().getRemoteSocketAddress();
    }
}

