/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.concurrent;

import java.util.concurrent.TimeoutException;
import org.pvalsecc.concurrent.SynchronousSimpleTarget;

public class BlockingSimpleTarget
extends SynchronousSimpleTarget {
    private boolean completed = false;
    private final Object sync = new Object();

    public BlockingSimpleTarget(String name) {
        super(name, null);
        this.registerCompletedCallback(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = BlockingSimpleTarget.this.sync;
                synchronized (object) {
                    BlockingSimpleTarget.this.completed = true;
                    BlockingSimpleTarget.this.sync.notifyAll();
                }
            }
        });
    }

    public BlockingSimpleTarget(int target, String name) {
        this(name);
        this.setTarget(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        Object object = this.sync;
        synchronized (object) {
            while (!this.completed) {
                try {
                    this.sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion(long timeout) throws TimeoutException {
        long maxTime = System.currentTimeMillis() + timeout;
        Object object = this.sync;
        synchronized (object) {
            while (!this.completed) {
                try {
                    long toWait = maxTime - System.currentTimeMillis();
                    if (toWait <= 0L) {
                        throw new TimeoutException();
                    }
                    this.sync.wait(toWait);
                }
                catch (InterruptedException ignored) {}
            }
        }
    }
}

