/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.graph.dijkstra;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.pvalsecc.graph.dijkstra.Edge;
import org.pvalsecc.graph.dijkstra.ReachableVecticesVisitor;
import org.pvalsecc.graph.dijkstra.Vertex;

public class Dijkstra<EDGE extends Edge> {
    private TreeSet<Vertex<EDGE>> vecticesToVisit = new TreeSet();
    private Map<Long, Vertex<EDGE>> vecticesMap = new HashMap<Long, Vertex<EDGE>>();

    public void addEdge(EDGE edge) {
        Vertex<EDGE> b;
        Vertex<EDGE> a = this.vecticesMap.get(edge.getVertexIdA());
        if (a == null) {
            a = new Vertex(edge.getVertexIdA());
            this.vecticesMap.put(a.getId(), a);
            this.vecticesToVisit.add(a);
        }
        if ((b = this.vecticesMap.get(edge.getVertexIdB())) == null) {
            b = new Vertex(edge.getVertexIdB());
            this.vecticesMap.put(b.getId(), b);
            this.vecticesToVisit.add(b);
        }
        if (!Double.isNaN(edge.getCost(Edge.Direction.A_TO_B))) {
            a.add(edge);
        }
        if (!Double.isNaN(edge.getCost(Edge.Direction.B_TO_A))) {
            b.add(edge);
        }
    }

    public List<EDGE> getShortestPath(long startId, long endId, Double maxCost) {
        this.compute(startId, endId, maxCost);
        Vertex<EDGE> cur = this.vecticesMap.get(endId);
        if (cur == null) {
            throw new RuntimeException("Cannot find vertex with id=" + endId);
        }
        if (cur.getPreviousEdge() == null) {
            return null;
        }
        ArrayList<EDGE> result = new ArrayList<EDGE>();
        while (cur != null && cur.getId() != startId) {
            EDGE edge = cur.getPreviousEdge();
            if (edge == null) {
                throw new RuntimeException("Broken path around " + cur);
            }
            result.add(edge);
            cur = this.getOtherVertex(edge, cur);
        }
        return result;
    }

    public void getReachableVectices(long startId, double maxCost, ReachableVecticesVisitor<EDGE> visitor) {
        this.compute(startId, null, maxCost);
        for (Vertex<EDGE> vertex : this.vecticesMap.values()) {
            long id = vertex.getId();
            if (vertex.getPreviousEdge() == null && id != startId) continue;
            double cost = vertex.getCost();
            visitor.vertex(id, (Edge)vertex.getPreviousEdge(), cost);
            List<EDGE> edges = vertex.getEdges();
            for (int i = 0; i < edges.size(); ++i) {
                Edge edge = (Edge)edges.get(i);
                if (!(this.getEdgeCost(edge, id) + cost > maxCost)) continue;
                visitor.exitEdge(id, edge);
            }
        }
    }

    private void compute(long startId, Long endId, Double maxCost) {
        Vertex<EDGE> start = this.vecticesMap.get(startId);
        if (start == null) {
            throw new RuntimeException("Cannot find the start vertex with id=" + startId);
        }
        this.vecticesToVisit.remove(start);
        start.setCost(0.0);
        this.vecticesToVisit.add(start);
        while (!this.vecticesToVisit.isEmpty()) {
            Vertex<EDGE> cur = this.vecticesToVisit.first();
            this.vecticesToVisit.remove(cur);
            double curCost = cur.getCost();
            if (curCost == Double.MAX_VALUE || endId != null && cur.getId() == endId.longValue()) break;
            List<EDGE> edges = cur.getEdges();
            for (int i = 0; i < edges.size(); ++i) {
                Edge edge = (Edge)edges.get(i);
                Vertex<Edge> linkedVertex = this.getOtherVertex(edge, cur);
                double newCost = curCost + this.getEdgeCost(edge, cur.getId());
                if (maxCost != null && newCost > maxCost || !(newCost < linkedVertex.getCost())) continue;
                boolean removed = this.vecticesToVisit.remove(linkedVertex);
                linkedVertex.setCost(newCost);
                linkedVertex.setPreviousEdge(edge);
                if (!removed) continue;
                this.vecticesToVisit.add(linkedVertex);
            }
        }
    }

    private Vertex<EDGE> getOtherVertex(EDGE edge, Vertex<EDGE> cur) {
        long linkedId = cur.getId() == edge.getVertexIdA() ? edge.getVertexIdB() : edge.getVertexIdA();
        Vertex<EDGE> result = this.vecticesMap.get(linkedId);
        if (result == null) {
            throw new RuntimeException("Cannot find linked vertex with id=" + linkedId);
        }
        return result;
    }

    private double getEdgeCost(EDGE edge, long fromId) {
        if (fromId == edge.getVertexIdA()) {
            return edge.getCost(Edge.Direction.A_TO_B);
        }
        if (fromId == edge.getVertexIdB()) {
            return edge.getCost(Edge.Direction.B_TO_A);
        }
        throw new RuntimeException("Inconsistency, edge " + edge + " is not linking vertex " + fromId);
    }

    public int getNbVectices() {
        return this.vecticesMap.size();
    }
}

