/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class StatementUtils {
    public static void copyDouble(ResultSet rs, int sourcePos, PreparedStatement stmt, int destPos) throws SQLException {
        double value = rs.getDouble(sourcePos);
        if (rs.wasNull()) {
            stmt.setNull(destPos, 8);
        } else {
            stmt.setDouble(destPos, value);
        }
    }

    public static void copyFloat(ResultSet rs, int sourcePos, PreparedStatement stmt, int destPos) throws SQLException {
        float value = rs.getFloat(sourcePos);
        if (rs.wasNull()) {
            stmt.setNull(destPos, 6);
        } else {
            stmt.setFloat(destPos, value);
        }
    }

    public static void copyInt(ResultSet rs, int sourcePos, PreparedStatement stmt, int destPos) throws SQLException {
        int value = rs.getInt(sourcePos);
        if (rs.wasNull()) {
            stmt.setNull(destPos, 4);
        } else {
            stmt.setInt(destPos, value);
        }
    }

    public static void copyLong(ResultSet rs, int sourcePos, PreparedStatement stmt, int destPos) throws SQLException {
        long value = rs.getLong(sourcePos);
        if (rs.wasNull()) {
            stmt.setNull(destPos, -5);
        } else {
            stmt.setLong(destPos, value);
        }
    }

    public static void copyString(ResultSet rs, int sourcePos, PreparedStatement stmt, int destPos) throws SQLException {
        String value = rs.getString(sourcePos);
        if (rs.wasNull()) {
            stmt.setNull(destPos, 12);
        } else {
            stmt.setString(destPos, value);
        }
    }
}

