/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.readers.MapReaderFactory;
import org.mapfish.print.map.readers.TileableMapReader;
import org.mapfish.print.map.readers.WMSServiceInfo;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;
import org.pvalsecc.misc.StringUtils;
import org.pvalsecc.misc.URIUtils;

public class WMSMapReader
extends TileableMapReader {
    private boolean strictEpsg4326;
    private static final WMSVersion DEFAULT_VERSION = WMSVersion.VERSION1_1_1;
    public static final Logger LOGGER = Logger.getLogger(WMSMapReader.class);
    private final String format;
    protected final List<String> layers = new ArrayList<String>();
    private WMSVersion version;
    private final List<String> styles = new ArrayList<String>();

    private WMSMapReader(String layer, String style, RenderingContext context, PJsonObject params) {
        super(context, params);
        this.layers.add(layer);
        if (!context.getConfig().isIgnoreCapabilities()) {
            this.tileCacheLayerInfo = WMSServiceInfo.getInfo(this.baseUrl, context).getTileCacheLayer(layer, context, params);
        }
        this.styles.add(style);
        this.format = params.getString("format");
        this.version = WMSVersion.find(params.optString("version", WMSMapReader.DEFAULT_VERSION.code));
        PJsonObject customParams = params.optJSONObject("customParams");
        if (customParams != null) {
            this.version = WMSVersion.find(customParams.optString("version", this.version.code));
        }
        if (this.version == WMSVersion.VERSION1_3_0 && params.optString("srs", context.getGlobalParams().optString("srs", "CRS:4326")).equals("EPSG:4326")) {
            this.strictEpsg4326 = true;
        }
    }

    @Override
    protected String getMergeableValue(PJsonObject customParams, List<String> toBeSkipped, String key) throws JSONException {
        if (customParams.optJSONArray(key) != null) {
            String value = null;
            PJsonArray listOfValues = customParams.getJSONArray(key);
            int notUsed = -1;
            for (int count = 0; count < listOfValues.size() && notUsed == -1; ++count) {
                value = listOfValues.getInternalArray().optString(count, null);
                if (value == null) continue;
                notUsed = count;
                listOfValues.getInternalArray().put(count, (Object)null);
            }
            if (notUsed == listOfValues.size() - 1) {
                toBeSkipped.add(key);
            }
            return value;
        }
        return super.getMergeableValue(customParams, toBeSkipped, key);
    }

    @Override
    protected TileRenderer.Format getFormat() {
        if (this.format.equals("image/svg+xml")) {
            return TileRenderer.Format.SVG;
        }
        if (this.format.equals("application/pdf") || this.format.equals("application/x-pdf")) {
            return TileRenderer.Format.PDF;
        }
        return TileRenderer.Format.BITMAP;
    }

    @Override
    public void render(Transformer transformer, ParallelMapTileLoader parallelMapTileLoader, String srs, boolean first) {
        PJsonObject customParams = this.params.optJSONObject("customParams");
        double oldAngle = transformer.getRotation();
        if (customParams != null && customParams.optString("angle") != null) {
            transformer.setRotation(0.0);
        }
        if (this.params.optBool("useNativeAngle", false)) {
            String angle = String.valueOf(-Math.toDegrees(transformer.getRotation()));
            try {
                if (customParams != null) {
                    customParams.getInternalObj().put("angle", (Object)angle);
                    customParams.getInternalObj().put("map_angle", (Object)angle);
                } else {
                    HashMap<String, String> customMap = new HashMap<String, String>();
                    customMap.put("angle", angle);
                    customMap.put("map_angle", angle);
                    this.params.getInternalObj().put("customParams", customMap);
                }
                transformer.setRotation(0.0);
            }
            catch (JSONException e) {
                LOGGER.error((Object)("Unable to set angle: " + ((Object)((Object)e)).getClass().getName() + " - " + e.getMessage()));
            }
        }
        super.render(transformer, parallelMapTileLoader, srs, first);
        transformer.setRotation(oldAngle);
    }

    @Override
    protected void addCommonQueryParams(Map<String, List<String>> result, Transformer transformer, String srs, boolean first) {
        URIUtils.setParamDefault(result, "FORMAT", this.format);
        URIUtils.setParamDefault(result, "LAYERS", StringUtils.join(this.layers, ","));
        URIUtils.setParamDefault(result, "SERVICE", "WMS");
        URIUtils.setParamDefault(result, "REQUEST", "GetMap");
        String versionParamName = "VERSION";
        switch (this.version) {
            case VERSION1_3_0: {
                URIUtils.setParamDefault(result, "CRS", srs);
                URIUtils.setParamDefault(result, "VERSION", this.version.code);
                break;
            }
            default: {
                URIUtils.setParamDefault(result, "SRS", srs);
                URIUtils.setParamDefault(result, "VERSION", WMSVersion.VERSION1_1_1.code);
            }
        }
        if (!first) {
            URIUtils.setParamDefault(result, "TRANSPARENT", "true");
        }
        URIUtils.setParamDefault(result, "STYLES", StringUtils.join(this.styles, ","));
        URIUtils.setParamDefault(result, "format_options", "dpi:" + transformer.getDpi());
        URIUtils.setParamDefault(result, "map_resolution", String.valueOf(transformer.getDpi()));
        URIUtils.setParamDefault(result, "DPI", String.valueOf(transformer.getDpi()));
    }

    @Override
    public boolean testMerge(MapReader other) {
        if (this.canMerge(other)) {
            WMSMapReader wms = (WMSMapReader)other;
            this.layers.addAll(wms.layers);
            this.styles.addAll(wms.styles);
            return super.testMerge(other);
        }
        return false;
    }

    @Override
    public boolean canMerge(MapReader other) {
        if (!super.canMerge(other)) {
            return false;
        }
        if (this.tileCacheLayerInfo != null && !this.context.getConfig().isTilecacheMerging()) {
            return false;
        }
        if (other instanceof WMSMapReader) {
            WMSMapReader wms = (WMSMapReader)other;
            if (!this.format.equals(wms.format)) {
                return false;
            }
            if (this.tileCacheLayerInfo != null && wms.tileCacheLayerInfo != null) {
                if (!this.tileCacheLayerInfo.equals(wms.tileCacheLayerInfo)) {
                    return false;
                }
            } else if (this.tileCacheLayerInfo == null != (wms.tileCacheLayerInfo == null)) {
                LOGGER.warn((Object)("Between [" + this + "] and [" + wms + "], one has a tile cache config and not the other"));
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected URI getTileUri(URI commonUri, Transformer transformer, double minGeoX, double minGeoY, double maxGeoX, double maxGeoY, long w, long h) throws URISyntaxException, UnsupportedEncodingException {
        String bbox;
        HashMap<String, List<String>> tileParams = new HashMap<String, List<String>>();
        if (this.format.equals("image/svg+xml")) {
            double maxW = this.context.getConfig().getMaxSvgW();
            double maxH = this.context.getConfig().getMaxSvgH();
            double width = transformer.getRotatedSvgW();
            double height = transformer.getRotatedSvgH();
            if (maxW < width || maxH < height) {
                if (maxW / maxH < width / height) {
                    double divisor = width / maxW;
                    width = maxW;
                    height /= divisor;
                } else {
                    double divisor = height / maxH;
                    height = maxH;
                    width /= divisor;
                }
            }
            URIUtils.addParamOverride(tileParams, "WIDTH", Long.toString(Math.round(width)));
            URIUtils.addParamOverride(tileParams, "HEIGHT", Long.toString(Math.round(height)));
        } else {
            URIUtils.addParamOverride(tileParams, "WIDTH", Long.toString(w));
            URIUtils.addParamOverride(tileParams, "HEIGHT", Long.toString(h));
        }
        switch (this.version) {
            case VERSION1_3_0: {
                if (this.strictEpsg4326) {
                    bbox = String.format("%s,%s,%s,%s", minGeoY, minGeoX, maxGeoY, maxGeoX);
                    break;
                }
                bbox = String.format("%s,%s,%s,%s", minGeoX, minGeoY, maxGeoX, maxGeoY);
                break;
            }
            default: {
                bbox = String.format("%s,%s,%s,%s", minGeoX, minGeoY, maxGeoX, maxGeoY);
            }
        }
        URIUtils.addParamOverride(tileParams, "BBOX", bbox);
        return URIUtils.addParams(commonUri, tileParams, OVERRIDE_ALL);
    }

    @Override
    public String toString() {
        return StringUtils.join(this.layers, ", ");
    }

    public static class Factory
    implements MapReaderFactory {
        public List<MapReader> create(String type, RenderingContext context, PJsonObject params) {
            ArrayList<MapReader> target = new ArrayList<MapReader>();
            PJsonArray layers = params.getJSONArray("layers");
            PJsonArray styles = params.optJSONArray("styles");
            for (int i = 0; i < layers.size(); ++i) {
                String layer = layers.getString(i);
                String style = "";
                if (styles != null && i < styles.size()) {
                    style = styles.getString(i);
                }
                target.add(new WMSMapReader(layer, style, context, params));
            }
            return target;
        }
    }

    static enum WMSVersion {
        VERSION1_1_1("1.1.1"),
        VERSION1_3_0("1.3.0");

        public final String code;

        private WMSVersion(String code) {
            this.code = code;
        }

        public static WMSVersion find(String version) {
            for (WMSVersion wmsVersion : WMSVersion.values()) {
                if (!wmsVersion.code.equals(version)) continue;
                return wmsVersion;
            }
            throw new IllegalArgumentException("WMS Version: " + version + " is not a supported version");
        }
    }
}

