/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.map.readers.HTTPMapReader;
import org.mapfish.print.map.readers.ServerInfoCache;
import org.mapfish.print.map.readers.ServiceInfo;
import org.mapfish.print.map.readers.WmtsCapabilitiesInfo;
import org.pvalsecc.misc.URIUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WMTSServiceInfo
extends ServiceInfo {
    private static final Log LOGGER = LogFactory.getLog(WMTSServiceInfo.class);
    private static final ServerInfoCache<WMTSServiceInfo> cache = new ServerInfoCache(new WMSServiceInfoLoader());
    final Map<String, WmtsCapabilitiesInfo> tileCacheLayers = new HashMap<String, WmtsCapabilitiesInfo>();

    public static synchronized void clearCache() {
        cache.clearCache();
    }

    public static WMTSServiceInfo getInfo(URI uri, RenderingContext context) {
        return cache.getInfo(uri, context);
    }

    public static WmtsCapabilitiesInfo getLayerInfo(URI uri, String layerId, RenderingContext context) {
        return WMTSServiceInfo.getInfo((URI)uri, (RenderingContext)context).tileCacheLayers.get(layerId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WMTSServerInfo");
        sb.append("{tileCacheLayers=").append(this.tileCacheLayers);
        sb.append('}');
        return sb.toString();
    }

    static class TileMatrixLimit {
        final String id;
        final int MinTileRow;
        final int MaxTileRow;
        final int MinTileCol;
        final int MaxTileCol;

        public TileMatrixLimit(Element el) {
            this.id = ServerInfoCache.ServiceInfoLoader.getTextContentOfChild(el, "TileMatrix");
            this.MinTileRow = Integer.parseInt(ServerInfoCache.ServiceInfoLoader.getTextContentOfChild(el, "MinTileRow"));
            this.MaxTileRow = Integer.parseInt(ServerInfoCache.ServiceInfoLoader.getTextContentOfChild(el, "MaxTileRow"));
            this.MinTileCol = Integer.parseInt(ServerInfoCache.ServiceInfoLoader.getTextContentOfChild(el, "MinTileCol"));
            this.MaxTileCol = Integer.parseInt(ServerInfoCache.ServiceInfoLoader.getTextContentOfChild(el, "MaxTileCol"));
        }
    }

    static class TileMatrixSet {
        final String id;
        final Map<String, TileMatrixLimit> limits;

        public TileMatrixSet(Element element) {
            this.id = ServerInfoCache.ServiceInfoLoader.getTextContentOfChild(element, "TileMatrixSet");
            HashMap<String, TileMatrixLimit> tmpLimits = new HashMap<String, TileMatrixLimit>();
            NodeList tileMatrixLimits = element.getElementsByTagName("TileMatrixLimits");
            for (int j = 0; j < tileMatrixLimits.getLength(); ++j) {
                Element el = (Element)tileMatrixLimits.item(j);
                TileMatrixLimit limit = new TileMatrixLimit(el);
                tmpLimits.put(limit.id, limit);
            }
            this.limits = Collections.unmodifiableMap(tmpLimits);
        }
    }

    static class WMSServiceInfoLoader
    extends ServerInfoCache.ServiceInfoLoader<WMTSServiceInfo> {
        WMSServiceInfoLoader() {
        }

        @Override
        public Log logger() {
            return LOGGER;
        }

        @Override
        public WMTSServiceInfo createNewErrorResult() {
            return new WMTSServiceInfo();
        }

        @Override
        public URL createURL(URI baseUrl, RenderingContext context) throws UnsupportedEncodingException, URISyntaxException, MalformedURLException {
            HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
            URIUtils.addParamOverride(queryParams, "SERVICE", "WMTS");
            URIUtils.addParamOverride(queryParams, "REQUEST", "GetCapabilities");
            URIUtils.addParamOverride(queryParams, "VERSION", "1.0.0");
            URL url = URIUtils.addParams(baseUrl, queryParams, HTTPMapReader.OVERRIDE_ALL).toURL();
            return url;
        }

        @Override
        public WMTSServiceInfo parseInfo(InputStream stream) throws ParserConfigurationException, IOException, SAXException {
            DocumentBuilder documentBuilder = ServiceInfo.documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document doc = documentBuilder.parse(stream);
            NodeList tileSets = doc.getElementsByTagName("Layer");
            WMTSServiceInfo result = new WMTSServiceInfo();
            if (tileSets.getLength() > 0) {
                for (int i = 0; i < tileSets.getLength(); ++i) {
                    try {
                        Element layer = (Element)tileSets.item(i);
                        String identifier = WMSServiceInfoLoader.getTextContentOfChild(layer, "Identifier");
                        String title = WMSServiceInfoLoader.getTextContentOfChild(layer, "Title", identifier);
                        ArrayList<String> formats = WMSServiceInfoLoader.getTextContentOfChildren(layer, "Format");
                        String[] lowerCorner = WMSServiceInfoLoader.getTextContextFromPath(layer, "WGS84BoundingBox/LowerCorner", "-180 -90").split(" ");
                        String[] upperCorner = WMSServiceInfoLoader.getTextContextFromPath(layer, "WGS84BoundingBox/UpperCorner", "180 90").split(" ");
                        Envelope bounds = new Envelope(Double.parseDouble(lowerCorner[0]), Double.parseDouble(upperCorner[0]), Double.parseDouble(lowerCorner[1]), Double.parseDouble(upperCorner[1]));
                        HashMap<String, TileMatrixSet> tileMatrices = new HashMap<String, TileMatrixSet>();
                        NodeList matrixSetLink = layer.getElementsByTagName("TileMatrixSetLink");
                        for (int j = 0; j < matrixSetLink.getLength(); ++j) {
                            Element element = (Element)matrixSetLink.item(j);
                            TileMatrixSet tileMatrixSet = new TileMatrixSet(element);
                            tileMatrices.put(tileMatrixSet.id, tileMatrixSet);
                        }
                        result.tileCacheLayers.put(identifier, new WmtsCapabilitiesInfo(identifier, title, formats, bounds, tileMatrices));
                        continue;
                    }
                    catch (NoSuchElementException e) {
                        LOGGER.warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            return result;
        }
    }
}

