/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.renderers.vector;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.awt.geom.Point2D;
import com.itextpdf.text.pdf.PdfContentByte;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.HashMap;
import java.util.Map;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.map.renderers.vector.LabelRenderer;
import org.mapfish.print.map.renderers.vector.LineStringRenderer;
import org.mapfish.print.map.renderers.vector.PointRenderer;
import org.mapfish.print.map.renderers.vector.PolygonRenderer;
import org.mapfish.print.utils.PJsonObject;

public abstract class GeometriesRenderer<T extends Geometry> {
    private static final Map<Class<? extends Geometry>, GeometriesRenderer<?>> RENDERERS = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void render(RenderingContext context, PdfContentByte dc, PJsonObject style, Geometry geometry, AffineTransform affineTransform) {
        GeometriesRenderer<?> renderer = RENDERERS.get(geometry.getClass());
        if (renderer == null) {
            throw new RuntimeException("Rendering of " + geometry.getClass().getName() + " not supported");
        }
        dc.saveState();
        try {
            renderer.renderImpl(context, dc, style, geometry, affineTransform);
        }
        finally {
            dc.restoreState();
        }
        dc.saveState();
        try {
            LabelRenderer.applyStyle(context, dc, style, geometry, affineTransform);
        }
        finally {
            dc.restoreState();
        }
    }

    protected abstract void renderImpl(RenderingContext var1, PdfContentByte var2, PJsonObject var3, T var4, AffineTransform var5);

    protected static Coordinate transformCoordinate(Coordinate coordinate, AffineTransform affineTransform) {
        Point2D.Double point2D = new Point2D.Double(coordinate.x, coordinate.y);
        affineTransform.transform((Point2D)point2D, (Point2D)point2D);
        coordinate.setCoordinate(new Coordinate(point2D.getX(), point2D.getY()));
        return coordinate;
    }

    static {
        RENDERERS.put(LineString.class, new LineStringRenderer());
        RENDERERS.put(LinearRing.class, new LineStringRenderer());
        RENDERERS.put(GeometryCollection.class, new GeometryCollectionRenderer());
        RENDERERS.put(MultiLineString.class, new GeometryCollectionRenderer());
        RENDERERS.put(MultiPoint.class, new GeometryCollectionRenderer());
        RENDERERS.put(MultiPolygon.class, new GeometryCollectionRenderer());
        RENDERERS.put(Polygon.class, new PolygonRenderer());
        RENDERERS.put(Point.class, new PointRenderer());
    }

    private static class GeometryCollectionRenderer
    extends GeometriesRenderer<GeometryCollection> {
        private GeometryCollectionRenderer() {
        }

        @Override
        protected void renderImpl(RenderingContext context, PdfContentByte dc, PJsonObject style, GeometryCollection geometry, AffineTransform affineTransform) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                GeometryCollectionRenderer.render(context, dc, style, geometry.getGeometryN(i), affineTransform);
            }
        }
    }
}

