/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import jsr166y.RecursiveTask;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.output.Values;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorExecutionContext;
import org.mapfish.print.processor.ProcessorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessorGraphNode<In, Out> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorGraphNode.class);
    private final Processor<In, Out> processor;
    private final List<ProcessorGraphNode<?, ?>> dependencies = Lists.newArrayList();
    private final List<ProcessorGraphNode<?, ?>> requirements = Lists.newArrayList();
    private final MetricRegistry metricRegistry;

    public ProcessorGraphNode(@Nonnull Processor<In, Out> processor, @Nonnull MetricRegistry metricRegistry) {
        this.processor = processor;
        this.metricRegistry = metricRegistry;
    }

    public Processor<?, ?> getProcessor() {
        return this.processor;
    }

    public void addDependency(ProcessorGraphNode node) {
        this.dependencies.add(node);
        node.addRequirement(this);
    }

    private void addRequirement(ProcessorGraphNode node) {
        this.requirements.add(node);
    }

    protected List<ProcessorGraphNode<?, ?>> getRequirements() {
        return this.requirements;
    }

    public boolean hasRequirements() {
        return !this.requirements.isEmpty();
    }

    public Optional<ProcessorNodeForkJoinTask> createTask(@Nonnull ProcessorExecutionContext execContext) {
        if (!execContext.tryStart(this)) {
            return Optional.absent();
        }
        return Optional.of(new ProcessorNodeForkJoinTask(this, execContext));
    }

    @Nonnull
    public BiMap<String, String> getOutputMapper() {
        BiMap<String, String> outputMapper = this.processor.getOutputMapperBiMap();
        if (outputMapper == null) {
            return HashBiMap.create();
        }
        return outputMapper;
    }

    @Nonnull
    public BiMap<String, String> getInputMapper() {
        BiMap<String, String> inputMapper = this.processor.getInputMapperBiMap();
        if (inputMapper == null) {
            return HashBiMap.create();
        }
        return inputMapper;
    }

    public void toString(StringBuilder builder, int indent) {
        int spaces = indent * 2;
        for (int i = 0; i < spaces; ++i) {
            builder.append(' ');
        }
        if (indent > 0) {
            builder.append("+-- ");
        }
        builder.append(this.processor);
        for (ProcessorGraphNode<?, ?> dependency : this.dependencies) {
            builder.append('\n');
            dependency.toString(builder, indent + 1);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder, 0);
        return builder.toString();
    }

    public String getName() {
        return this.processor.toString();
    }

    public Set<? extends Processor<?, ?>> getAllProcessors() {
        IdentityHashMap all = new IdentityHashMap();
        all.put(this.getProcessor(), null);
        for (ProcessorGraphNode<?, ?> dependency : this.dependencies) {
            for (Processor<?, ?> p : dependency.getAllProcessors()) {
                all.put(p, null);
            }
        }
        return all.keySet();
    }

    public static final class ProcessorNodeForkJoinTask<In, Out>
    extends RecursiveTask<Values> {
        private final ProcessorExecutionContext execContext;
        private final ProcessorGraphNode<In, Out> node;

        private ProcessorNodeForkJoinTask(ProcessorGraphNode<In, Out> node, ProcessorExecutionContext execContext) {
            this.node = node;
            this.execContext = execContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Values compute() {
            Values values = this.execContext.getValues();
            Processor process = ((ProcessorGraphNode)this.node).processor;
            MetricRegistry registry = ((ProcessorGraphNode)this.node).metricRegistry;
            String name = ProcessorGraphNode.class.getName() + "_compute():" + process.getClass();
            Timer.Context timerContext = registry.timer(name).time();
            try {
                Object output;
                Object inputParameter = ProcessorUtils.populateInputParameter(process, values);
                try {
                    LOGGER.info("Executing process: " + process);
                    output = process.execute(inputParameter, this.execContext.getContext());
                    LOGGER.info("Succeeded in executing process: " + process);
                }
                catch (Exception e) {
                    if (this.execContext.getContext().isCanceled()) {
                        throw new CancellationException();
                    }
                    LOGGER.error("Error while executing process: " + process, (Throwable)e);
                    throw ExceptionUtils.getRuntimeException(e);
                }
                if (output != null) {
                    ProcessorUtils.writeProcessorOutputToValues(output, process, values);
                }
            }
            finally {
                this.execContext.finished(this.node);
                long processorTime = TimeUnit.MILLISECONDS.convert(timerContext.stop(), TimeUnit.NANOSECONDS);
                LOGGER.debug("Time taken to run processor: '" + process.getClass() + "' was " + processorTime + " ms");
            }
            if (this.execContext.getContext().isCanceled()) {
                throw new CancellationException();
            }
            this.executeDependencyProcessors();
            return values;
        }

        private void executeDependencyProcessors() {
            List dependencyNodes = ((ProcessorGraphNode)this.node).dependencies;
            ArrayList<Object> tasks = new ArrayList<Object>(dependencyNodes.size());
            for (ProcessorGraphNode depNode : dependencyNodes) {
                Optional<ProcessorNodeForkJoinTask> task = depNode.createTask(this.execContext);
                if (!task.isPresent()) continue;
                tasks.add(task.get());
                if (tasks.size() <= 1) continue;
                ((ProcessorNodeForkJoinTask)((Object)task.get())).fork();
            }
            if (!tasks.isEmpty()) {
                ((ProcessorNodeForkJoinTask)((Object)tasks.get(0))).compute();
                for (ProcessorNodeForkJoinTask task : tasks.subList(1, tasks.size())) {
                    task.join();
                }
            }
        }
    }
}

