/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.servlet.job.PrintJobStatus;

public class FailedPrintJob
extends PrintJobStatus {
    private static final String JSON_ERROR = "errorMessage";
    private static final String JSON_CANCELLED = "cancelled";
    private final String error;
    private final boolean cancelled;

    public FailedPrintJob(String referenceId, String appId, Date startDate, Date completionDate, long requestCount, String fileName, String error, boolean cancelled, AccessAssertion access) {
        super(referenceId, appId, startDate, completionDate, requestCount, fileName, access);
        this.error = error;
        this.cancelled = cancelled;
    }

    @Override
    protected final void addExtraParameters(JSONObject metadata) throws JSONException {
        metadata.put(JSON_ERROR, (Object)this.error);
        metadata.put(JSON_CANCELLED, this.cancelled);
    }

    public static FailedPrintJob load(JSONObject metadata, String referenceId, String appId, Date startDate, Date completionDate, long requestCount, String fileName, AccessAssertion reportAccess) throws JSONException {
        String error = metadata.getString(JSON_ERROR);
        boolean cancelled = metadata.getBoolean(JSON_CANCELLED);
        return new FailedPrintJob(referenceId, appId, startDate, completionDate, requestCount, fileName, error, cancelled, reportAccess);
    }

    public final String getError() {
        return this.error;
    }

    public final boolean getCancelled() {
        return this.cancelled;
    }
}

