/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONWriter;
import org.mapfish.print.PrintException;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.attribute.InternalAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.output.Values;
import org.mapfish.print.parser.MapfishParser;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.yaml.PYamlArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceAttribute
implements Attribute {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceAttribute.class);
    private Map<String, Attribute> attributes = Maps.newHashMap();
    private String configName;
    private PYamlArray defaults;

    public void setDefault(List<Object> defaultData) {
        this.defaults = new PYamlArray(null, defaultData, "dataSource");
    }

    public void setAttributes(Map<String, Attribute> attributes) {
        for (Map.Entry<String, Attribute> entry : attributes.entrySet()) {
            Attribute attribute = entry.getValue();
            if (!(attribute instanceof Attribute)) {
                String msg = "Attribute: '" + entry.getKey() + "' is not an attribute. It is a: " + attribute;
                LOGGER.error("Error setting the Attributes: " + msg);
                throw new IllegalArgumentException(msg);
            }
            attribute.setConfigName(entry.getKey());
        }
        this.attributes = attributes;
    }

    @Override
    public void printClientConfig(JSONWriter json, Template template) throws JSONException {
        try {
            json.key("name").value((Object)this.configName);
            json.key("type").value((Object)DataSourceAttributeValue.class.getSimpleName());
            json.key("clientParams");
            json.object();
            json.key("attributes");
            json.array();
            for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
                Attribute attribute = entry.getValue();
                if (attribute.getClass().getAnnotation(InternalAttribute.class) != null) continue;
                json.object();
                json.key("name").value((Object)entry.getKey());
                attribute.printClientConfig(json, template);
                json.endObject();
            }
            json.endArray();
            json.endObject();
        }
        catch (Throwable e) {
            throw new Error("Error printing the clientConfig of: " + DataSourceAttribute.class.getName(), e);
        }
    }

    @Override
    public void setConfigName(String name) {
        this.configName = name;
    }

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
    }

    public DataSourceAttributeValue parseAttribute(@Nonnull MapfishParser parser, @Nonnull Template template, @Nullable PArray jsonValue) throws JSONException {
        PArray pValue = jsonValue != null ? jsonValue : this.defaults;
        if (pValue == null) {
            throw new PrintException("Missing required attribute: " + this.configName);
        }
        DataSourceAttributeValue value = new DataSourceAttributeValue();
        value.attributesValues = new Map[pValue.size()];
        for (int i = 0; i < pValue.size(); ++i) {
            PObject rowData = pValue.getObject(i);
            Values valuesForParsing = new Values();
            valuesForParsing.populateFromAttributes(template, parser, this.attributes, rowData);
            value.attributesValues[i] = valuesForParsing.asMap();
        }
        return value;
    }

    public static final class DataSourceAttributeValue {
        public Map<String, Object>[] attributesValues;
    }
}

