/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute;

import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import org.mapfish.print.attribute.ReflectiveAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.Template;
import org.mapfish.print.map.style.json.ColorParser;
import org.mapfish.print.parser.HasDefaultValue;

public class NorthArrowAttribute
extends ReflectiveAttribute<NorthArrowAttributeValues> {
    private Integer size = null;
    private Boolean createSubReport = true;

    @Override
    public final void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.size == null || this.size < 1) {
            validationErrors.add(new ConfigurationException("size field is not legal: " + this.size + " in " + this.getClass().getName()));
        }
    }

    @Override
    public final NorthArrowAttributeValues createValue(Template template) {
        return new NorthArrowAttributeValues(new Dimension(this.size, this.size), this.createSubReport);
    }

    @Override
    protected final Class<? extends NorthArrowAttributeValues> getValueType() {
        return NorthArrowAttributeValues.class;
    }

    public final Integer getSize() {
        return this.size;
    }

    public final void setSize(Integer size) {
        this.size = size;
    }

    public final Boolean getCreateSubReport() {
        return this.createSubReport;
    }

    public final void setCreateSubReport(Boolean createSubReport) {
        this.createSubReport = createSubReport;
    }

    public class NorthArrowAttributeValues {
        private static final String DEFAULT_BACKGROUND_COLOR = "rgba(255, 255, 255, 0)";
        private final Dimension size;
        private final boolean createSubReport;
        @HasDefaultValue
        public String graphic = null;
        @HasDefaultValue
        public String backgroundColor = "rgba(255, 255, 255, 0)";

        public NorthArrowAttributeValues(Dimension size, boolean createSubReport) {
            this.size = size;
            this.createSubReport = createSubReport;
        }

        public final void postConstruct() {
            if (this.backgroundColor != null && !ColorParser.canParseColor(this.backgroundColor)) {
                throw new IllegalArgumentException("invalid background color: " + this.backgroundColor);
            }
        }

        public final Dimension getSize() {
            return this.size;
        }

        public final String getGraphic() {
            return this.graphic;
        }

        public final Color getBackgroundColor() {
            return ColorParser.toColor(this.backgroundColor);
        }

        public final boolean isCreateSubReport() {
            return this.createSubReport;
        }
    }
}

