/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style.json;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.Constants;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.ParserPluginUtils;
import org.mapfish.print.map.style.StyleParserPlugin;
import org.mapfish.print.map.style.json.MapfishJsonStyleVersion1;
import org.mapfish.print.map.style.json.MapfishJsonStyleVersion2;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.springframework.http.client.ClientHttpRequestFactory;

public final class MapfishJsonStyleParserPlugin
implements StyleParserPlugin {
    static final String JSON_VERSION = "version";
    private StyleBuilder sldStyleBuilder = new StyleBuilder();

    @Override
    public Optional<Style> parseStyle(final @Nullable Configuration configuration, @Nonnull ClientHttpRequestFactory clientHttpRequestFactory, @Nonnull String styleString, @Nonnull MapfishMapContext mapContext) throws Throwable {
        Optional<Style> styleOptional = this.tryLoadJson(configuration, styleString);
        if (styleOptional.isPresent()) {
            return styleOptional;
        }
        return ParserPluginUtils.loadStyleAsURI(clientHttpRequestFactory, styleString, new Function<byte[], Optional<Style>>(){

            public Optional<Style> apply(byte[] input) {
                try {
                    return MapfishJsonStyleParserPlugin.this.tryLoadJson(configuration, new String(input, Constants.DEFAULT_CHARSET));
                }
                catch (JSONException e) {
                    throw ExceptionUtils.getRuntimeException(e);
                }
            }
        });
    }

    private Optional<Style> tryLoadJson(Configuration configuration, String styleString) throws JSONException {
        String trimmed = styleString.trim();
        if (trimmed.startsWith("{") && trimmed.endsWith("}")) {
            PJsonObject json = new PJsonObject(new JSONObject(styleString), "style");
            String jsonVersion = json.optString(JSON_VERSION, "1");
            for (Versions versions : Versions.values()) {
                if (!versions.versionNumber.equals(jsonVersion)) continue;
                return Optional.of((Object)versions.parseStyle(json, this.sldStyleBuilder, configuration));
            }
        }
        return Optional.absent();
    }

    static enum Versions {
        ONE("1"){

            @Override
            Style parseStyle(PJsonObject json, StyleBuilder styleBuilder, Configuration configuration) {
                return new MapfishJsonStyleVersion1(json, styleBuilder, configuration, "geometry").parseStyle();
            }
        }
        ,
        TWO("2"){

            @Override
            Style parseStyle(PJsonObject json, StyleBuilder styleBuilder, Configuration configuration) {
                return new MapfishJsonStyleVersion2(json, styleBuilder, configuration).parseStyle();
            }
        };

        private final String versionNumber;

        private Versions(String versionNumber) {
            this.versionNumber = versionNumber;
        }

        abstract Style parseStyle(PJsonObject var1, StyleBuilder var2, Configuration var3);
    }
}

