/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Objects;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.util.Assert;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.processor.CustomDependencies;
import org.mapfish.print.processor.InternalValue;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.ProcessorDependency;
import org.mapfish.print.processor.ProcessorDependencyGraph;
import org.mapfish.print.processor.ProcessorGraphNode;
import org.mapfish.print.processor.ProcessorUtils;
import org.springframework.beans.factory.annotation.Autowired;

public final class ProcessorDependencyGraphFactory {
    @Autowired
    private MetricRegistry metricRegistry;
    @Autowired(required=false)
    private List<ProcessorDependency> dependencies = Lists.newArrayList();

    public void setDependencies(List<ProcessorDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public ProcessorDependencyGraph build(List<? extends Processor> processors) {
        ProcessorDependencyGraph graph = new ProcessorDependencyGraph();
        HashMap<String, ProcessorGraphNode<Object, Object>> provideBy = new HashMap<String, ProcessorGraphNode<Object, Object>>();
        HashMap outputTypes = new HashMap();
        ArrayList<ProcessorGraphNode<Object, Object>> nodes = new ArrayList<ProcessorGraphNode<Object, Object>>(processors.size());
        for (Processor processor : processors) {
            ProcessorGraphNode<Object, Object> processorGraphNode = new ProcessorGraphNode<Object, Object>(processor, this.metricRegistry);
            for (OutputValue value : ProcessorDependencyGraphFactory.getOutputValues(processorGraphNode)) {
                String outputName = value.getName();
                if (provideBy.containsKey(outputName)) {
                    if (value.canBeRenamed()) {
                        outputName = outputName + "_" + UUID.randomUUID().toString();
                    } else {
                        throw new IllegalArgumentException("Multiple processors provide the same output mapping: '" + processor + "' and '" + provideBy.get(outputName) + "' both provide: '" + outputName + "'.  You have to rename one of the outputs and the corresponding input so that there is no ambiguity with regards to the input a processor consumes.");
                    }
                }
                provideBy.put(outputName, processorGraphNode);
                outputTypes.put(outputName, value.getType());
            }
            nodes.add(processorGraphNode);
        }
        ArrayList allDependencies = Lists.newArrayList(this.dependencies);
        for (ProcessorGraphNode processorGraphNode : nodes) {
            if (!(processorGraphNode.getProcessor() instanceof CustomDependencies)) continue;
            CustomDependencies customDependencies = (CustomDependencies)((Object)processorGraphNode.getProcessor());
            allDependencies.addAll(customDependencies.createDependencies(nodes));
        }
        SetMultimap<ProcessorGraphNode<Object, Object>, InputValue> setMultimap = this.cacheInputsForNodes(nodes);
        for (ProcessorGraphNode processorGraphNode : nodes) {
            Set inputs = setMultimap.get((Object)processorGraphNode);
            this.checkExternalDependencies(allDependencies, processorGraphNode, nodes);
            for (InputValue input : inputs) {
                Class outputType;
                ProcessorGraphNode solution = (ProcessorGraphNode)provideBy.get(input.getName());
                if (solution == null || solution == processorGraphNode) continue;
                Class<?> inputType = input.getType();
                if (inputType.isAssignableFrom(outputType = (Class)outputTypes.get(input.getName()))) {
                    solution.addDependency(processorGraphNode);
                    continue;
                }
                throw new IllegalArgumentException("Type conflict: Processor '" + solution.getName() + "' provides an output with name '" + input.getName() + "' and of type '" + outputType + " ', while processor '" + processorGraphNode.getName() + "' expects an input of that name with type '" + inputType + "'! Please rename one of the attributes in the mappings of the processors.");
            }
        }
        for (ProcessorGraphNode processorGraphNode : nodes) {
            if (processorGraphNode.hasRequirements() || !this.hasNoneOrOnlyExternalInput(processorGraphNode, setMultimap.get((Object)processorGraphNode), provideBy)) continue;
            graph.addRoot(processorGraphNode);
        }
        Assert.isTrue((boolean)graph.getAllProcessors().containsAll(processors), (String)("'" + graph + "' does not contain all the processors: " + processors));
        return graph;
    }

    private void checkExternalDependencies(List<ProcessorDependency> allDependencies, ProcessorGraphNode<Object, Object> node, List<ProcessorGraphNode<Object, Object>> nodes) {
        for (ProcessorDependency dependency : allDependencies) {
            if (!dependency.getRequired().equals(node.getProcessor().getClass())) continue;
            for (ProcessorGraphNode<Object, Object> dependentNode : nodes) {
                if (!dependency.getDependent().equals(dependentNode.getProcessor().getClass())) continue;
                if (dependency.getCommonInputs().isEmpty()) {
                    node.addDependency(dependentNode);
                    continue;
                }
                boolean allRequiredInputsInCommon = true;
                for (String requiredInput : dependency.getCommonInputs()) {
                    String requiredNodeInput = this.getRequiredNodeInput(requiredInput);
                    String dependentNodeInput = this.getDependentNodeInput(requiredInput);
                    String mappedKey = this.getMappedKey(node, requiredNodeInput);
                    if (this.getOriginalKey(dependentNode, mappedKey).equals(dependentNodeInput)) continue;
                    allRequiredInputsInCommon = false;
                    break;
                }
                if (!allRequiredInputsInCommon) continue;
                node.addDependency(dependentNode);
            }
        }
    }

    private String getDependentNodeInput(String requiredInput) {
        if (!requiredInput.contains(";")) {
            return requiredInput;
        }
        return requiredInput.substring(requiredInput.indexOf(";") + 1);
    }

    private String getRequiredNodeInput(String requiredInput) {
        if (!requiredInput.contains(";")) {
            return requiredInput;
        }
        return requiredInput.substring(0, requiredInput.indexOf(";"));
    }

    private String getMappedKey(ProcessorGraphNode<Object, Object> node, String requiredInput) {
        String inputName = requiredInput;
        if (node.getInputMapper().containsValue((Object)requiredInput)) {
            inputName = (String)node.getInputMapper().inverse().get((Object)requiredInput);
        }
        return inputName;
    }

    private String getOriginalKey(ProcessorGraphNode<Object, Object> node, String mappedKey) {
        String inputName = mappedKey;
        if (node.getInputMapper().containsKey((Object)mappedKey)) {
            inputName = (String)node.getInputMapper().get((Object)mappedKey);
        }
        return inputName;
    }

    private SetMultimap<ProcessorGraphNode<Object, Object>, InputValue> cacheInputsForNodes(List<ProcessorGraphNode<Object, Object>> nodes) {
        HashMultimap inputsForNodes = HashMultimap.create();
        for (ProcessorGraphNode<Object, Object> node : nodes) {
            Set<InputValue> inputs = ProcessorDependencyGraphFactory.getInputs(node);
            inputsForNodes.putAll(node, inputs);
        }
        return inputsForNodes;
    }

    private boolean hasNoneOrOnlyExternalInput(ProcessorGraphNode<Object, Object> node, Set<InputValue> inputs, Map<String, ProcessorGraphNode<Object, Object>> provideBy) {
        if (inputs.isEmpty()) {
            return true;
        }
        for (InputValue input : inputs) {
            ProcessorGraphNode<Object, Object> provider = provideBy.get(input.getName());
            if (provider == null || provider == node) continue;
            return false;
        }
        return true;
    }

    private static Set<InputValue> getInputs(ProcessorGraphNode<Object, Object> node) {
        BiMap<String, String> inputMapper = node.getInputMapper();
        HashSet inputs = Sets.newHashSet();
        Object inputParameter = node.getProcessor().createInputParameter();
        if (inputParameter != null) {
            ProcessorDependencyGraphFactory.verifyAllMappingsMatchParameter(inputMapper.values(), inputParameter.getClass(), "One or more of the input mapping values of '" + node + "'  do not match an input parameter.  The bad mappings are");
            Collection<Field> allProperties = ParserUtils.getAllAttributes(inputParameter.getClass());
            for (Field field : allProperties) {
                String name = ProcessorUtils.getInputValueName(node.getProcessor().getInputPrefix(), inputMapper, field.getName());
                inputs.add(new InputValue(name, field.getType()));
            }
        }
        return inputs;
    }

    private static Collection<OutputValue> getOutputValues(ProcessorGraphNode<Object, Object> node) {
        BiMap<String, String> outputMapper = node.getOutputMapper();
        HashSet values = Sets.newHashSet();
        Set<String> mappings = outputMapper.keySet();
        Class<?> paramType = node.getProcessor().getOutputType();
        ProcessorDependencyGraphFactory.verifyAllMappingsMatchParameter(mappings, paramType, "One or more of the output mapping keys of '" + node + "' do not match an output parameter.  The bad mappings are: ");
        Collection<Field> allProperties = ParserUtils.getAllAttributes(paramType);
        for (Field field : allProperties) {
            boolean canBeRenamed = field.getAnnotation(InternalValue.class) != null;
            String name = ProcessorUtils.getOutputValueName(node.getProcessor().getOutputPrefix(), outputMapper, field);
            values.add(new OutputValue(name, canBeRenamed, field.getType()));
        }
        return values;
    }

    private static void verifyAllMappingsMatchParameter(Set<String> mappings, Class<?> paramType, String errorMessagePrefix) {
        Set<String> attributeNames = ParserUtils.getAllAttributeNames(paramType);
        StringBuilder errors = new StringBuilder();
        for (String mapping : mappings) {
            if (attributeNames.contains(mapping)) continue;
            errors.append("\n  * ").append(mapping);
        }
        Assert.isTrue((0 == errors.length() ? 1 : 0) != 0, (String)(errorMessagePrefix + errors + ProcessorDependencyGraphFactory.listOptions(attributeNames) + "\n"));
    }

    private static String listOptions(Set<String> attributeNames) {
        StringBuilder msg = new StringBuilder("\n\nThe possible parameter names are:");
        for (String attributeName : attributeNames) {
            msg.append("\n  * ").append(attributeName);
        }
        return msg.toString();
    }

    private static final class OutputValue
    extends InputValue {
        private final boolean canBeRenamed;

        private OutputValue(String name, boolean canBeRenamed, Class<?> type) {
            super(name, type);
            this.canBeRenamed = canBeRenamed;
        }

        public boolean canBeRenamed() {
            return this.canBeRenamed;
        }
    }

    private static class InputValue {
        private final String name;
        private final Class<?> type;

        public InputValue(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return Objects.equal((Object)this.name, (Object)((InputValue)obj).name);
        }

        public final String getName() {
            return this.name;
        }

        public final Class<?> getType() {
            return this.type;
        }

        public String toString() {
            return "InputValue{name='" + this.name + '\'' + ", type=" + this.type.getSimpleName() + '}';
        }
    }
}

