/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import org.mapfish.print.attribute.NorthArrowAttribute;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.jasper.ImagesSubReport;
import org.mapfish.print.processor.map.NorthArrowGraphic;

public class CreateNorthArrowProcessor
extends AbstractProcessor<Input, Output> {
    protected CreateNorthArrowProcessor() {
        super(Output.class);
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    @Override
    public final Input createInputParameter() {
        return new Input();
    }

    @Override
    public final Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        this.checkCancelState(context);
        double dpiRatio = values.map.getDpi() / values.map.getRequestorDPI();
        Dimension size = new Dimension((int)(values.northArrow.getSize().getWidth() * dpiRatio), (int)(values.northArrow.getSize().getHeight() * dpiRatio));
        URI northArrowGraphicFile = NorthArrowGraphic.create(size, values.northArrow.getGraphic(), values.northArrow.getBackgroundColor(), values.map.getRotation(), values.tempTaskDirectory, values.clientHttpRequestFactory);
        this.checkCancelState(context);
        String strScalebarSubReport = null;
        if (values.northArrow.isCreateSubReport()) {
            URI scalebarSubReport = this.createNorthArrowSubReport(values.tempTaskDirectory, values.northArrow.getSize(), Lists.newArrayList((Object[])new URI[]{northArrowGraphicFile}), values.map.getDpi());
            strScalebarSubReport = scalebarSubReport.toString();
        }
        return new Output(northArrowGraphicFile.toString(), strScalebarSubReport);
    }

    private URI createNorthArrowSubReport(File printDirectory, Dimension size, List<URI> graphics, double dpi) throws IOException, JRException {
        ImagesSubReport subReport = new ImagesSubReport(graphics, size, dpi);
        File compiledReport = File.createTempFile("north-arrow-report-", ".jasper", printDirectory);
        subReport.compile(compiledReport);
        return compiledReport.toURI();
    }

    public static final class Output {
        public final String northArrowGraphic;
        public final String northArrowSubReport;

        private Output(String northArrowGraphic, String northArrowSubReport) {
            this.northArrowGraphic = northArrowGraphic;
            this.northArrowSubReport = northArrowSubReport;
        }
    }

    public static class Input {
        public MapAttribute.MapAttributeValues map;
        public NorthArrowAttribute.NorthArrowAttributeValues northArrow;
        public File tempTaskDirectory;
        public MfClientHttpRequestFactory clientHttpRequestFactory;
    }
}

