/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Rectangle;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapBounds {
    private final CoordinateReferenceSystem projection;
    private static final Logger LOGGER = LoggerFactory.getLogger(MapBounds.class);

    protected MapBounds(CoordinateReferenceSystem projection) {
        this.projection = projection;
    }

    public abstract ReferencedEnvelope toReferencedEnvelope(Rectangle var1, double var2);

    public abstract MapBounds adjustedEnvelope(Rectangle var1);

    public final CoordinateReferenceSystem getProjection() {
        return this.projection;
    }

    public abstract MapBounds adjustBoundsToNearestScale(ZoomLevels var1, double var2, ZoomLevelSnapStrategy var4, boolean var5, Rectangle var6, double var7);

    public abstract double getScaleDenominator(Rectangle var1, double var2);

    public abstract MapBounds adjustBoundsToRotation(double var1);

    public abstract MapBounds zoomOut(double var1);

    public abstract MapBounds zoomToScale(double var1);

    public abstract Coordinate getCenter();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBounds mapBounds = (MapBounds)o;
        return this.projection.equals(mapBounds.projection);
    }

    public int hashCode() {
        return this.projection.hashCode();
    }
}

