/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import com.google.common.collect.Lists;
import com.vividsolutions.jts.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.ConfigurableRequest;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.http.MfClientHttpRequestFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class ConfigFileResolvingHttpRequestFactory
implements MfClientHttpRequestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileResolvingHttpRequestFactory.class);
    private final Configuration config;
    private final MfClientHttpRequestFactoryImpl httpRequestFactory;
    private final List<MfClientHttpRequestFactory.RequestConfigurator> callbacks = Lists.newCopyOnWriteArrayList();

    public ConfigFileResolvingHttpRequestFactory(MfClientHttpRequestFactoryImpl httpRequestFactory, Configuration config) {
        this.httpRequestFactory = httpRequestFactory;
        this.config = config;
    }

    @Override
    public void register(@Nonnull MfClientHttpRequestFactory.RequestConfigurator callback) {
        this.callbacks.add(callback);
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new ConfigFileResolvingRequest(uri, httpMethod);
    }

    private class ConfigFileResolvingRequest
    extends AbstractClientHttpRequest {
        private final URI uri;
        private final HttpMethod httpMethod;
        private ConfigurableRequest request;

        ConfigFileResolvingRequest(URI uri, HttpMethod httpMethod) {
            this.uri = uri;
            this.httpMethod = httpMethod;
        }

        protected synchronized OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
            Assert.isTrue((this.request == null ? 1 : 0) != 0, (String)"getBodyInternal() can only be called once.");
            this.request = this.createRequestFromWrapped(headers);
            return this.request.getBody();
        }

        private synchronized ConfigurableRequest createRequestFromWrapped(HttpHeaders headers) throws IOException {
            MfClientHttpRequestFactoryImpl requestFactory = ConfigFileResolvingHttpRequestFactory.this.httpRequestFactory;
            ConfigurableRequest httpRequest = requestFactory.createRequest(this.uri, this.httpMethod);
            httpRequest.setConfiguration(ConfigFileResolvingHttpRequestFactory.this.config);
            httpRequest.getHeaders().putAll((Map)headers);
            return httpRequest;
        }

        protected synchronized ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
            if (this.request != null) {
                LOGGER.debug("Executing http request: " + this.request.getURI());
                return this.executeCallbacksAndRequest(this.request);
            }
            if (this.httpMethod == HttpMethod.GET) {
                String uriString = this.uri.toString();
                Configuration configuration = ConfigFileResolvingHttpRequestFactory.this.config;
                try {
                    byte[] bytes = configuration.loadFile(uriString);
                    ConfigFileResolverHttpResponse response = new ConfigFileResolverHttpResponse(bytes, headers);
                    LOGGER.debug("Resolved request: " + uriString + " using mapfish print config file loaders.");
                    return response;
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            LOGGER.debug("Executing http request: " + this.getURI());
            return this.executeCallbacksAndRequest(this.createRequestFromWrapped(headers));
        }

        private ClientHttpResponse executeCallbacksAndRequest(ConfigurableRequest requestToExecute) throws IOException {
            for (MfClientHttpRequestFactory.RequestConfigurator callback : ConfigFileResolvingHttpRequestFactory.this.callbacks) {
                callback.configureRequest(requestToExecute);
            }
            return requestToExecute.execute();
        }

        public HttpMethod getMethod() {
            return this.httpMethod;
        }

        public URI getURI() {
            return this.uri;
        }

        private class ConfigFileResolverHttpResponse
        implements ClientHttpResponse {
            private final HttpHeaders headers;
            private final byte[] bytes;

            ConfigFileResolverHttpResponse(byte[] bytes, HttpHeaders headers) {
                this.headers = headers;
                this.bytes = bytes;
            }

            public HttpStatus getStatusCode() throws IOException {
                return HttpStatus.OK;
            }

            public int getRawStatusCode() throws IOException {
                return this.getStatusCode().value();
            }

            public String getStatusText() throws IOException {
                return "OK";
            }

            public void close() {
            }

            public InputStream getBody() throws IOException {
                return new ByteArrayInputStream(this.bytes);
            }

            public HttpHeaders getHeaders() {
                return this.headers;
            }
        }
    }
}

