/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.geotools.data.FeatureSource;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayer;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayerPlugin;
import org.mapfish.print.map.geotools.AbstractVectorLayerParam;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.FeaturesParser;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.parser.HasDefaultValue;

public final class GeoJsonLayer
extends AbstractFeatureSourceLayer {
    public GeoJsonLayer(ExecutorService executorService, FeatureSourceSupplier featureSourceSupplier, StyleSupplier<FeatureSource> styleSupplier, boolean renderAsSvg, AbstractLayerParams params) {
        super(executorService, featureSourceSupplier, styleSupplier, renderAsSvg, params);
    }

    public static class GeoJsonParam
    extends AbstractVectorLayerParam {
        @HasDefaultValue
        public String geoJson = "{\"type\": \"FeatureCollection\", \"features\": []}";
    }

    public static final class Plugin
    extends AbstractFeatureSourceLayerPlugin<GeoJsonParam> {
        private static final String TYPE = "geojson";
        private static final String COMPATIBILITY_TYPE = "vector";

        public Plugin() {
            super(TYPE, COMPATIBILITY_TYPE);
        }

        @Override
        public GeoJsonParam createParameter() {
            return new GeoJsonParam();
        }

        @Nonnull
        public GeoJsonLayer parse(@Nonnull Template template, @Nonnull GeoJsonParam param) throws IOException {
            return new GeoJsonLayer(this.forkJoinPool, this.createFeatureSourceSupplier(template, param.geoJson), this.createStyleFunction(template, param.style), template.getConfiguration().renderAsSvg(param.renderAsSvg), param);
        }

        private FeatureSourceSupplier createFeatureSourceSupplier(final Template template, final String geoJsonString) {
            return new FeatureSourceSupplier(){

                @Override
                @Nonnull
                public FeatureSource load(@Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext mapContext) {
                    FeaturesParser parser = new FeaturesParser(requestFactory, mapContext.isForceLongitudeFirst());
                    try {
                        SimpleFeatureCollection featureCollection = parser.autoTreat(template, geoJsonString);
                        return new CollectionFeatureSource(featureCollection);
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.getRuntimeException(e);
                    }
                }
            };
        }
    }
}

