/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.mapfish.print.map.tiled.AbstractTiledLayerParams;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.json.PJsonObject;

public abstract class AbstractWMXLayerParams
extends AbstractTiledLayerParams {
    @HasDefaultValue
    public PObject customParams;
    private final Multimap<String, String> additionalCustomParam = HashMultimap.create();
    @HasDefaultValue
    public PJsonObject mergeableParams;

    public final Multimap<String, String> getCustomParams() {
        Multimap<String, String> result = this.convertToMultiMap(this.customParams);
        result.putAll(this.additionalCustomParam);
        return result;
    }

    public final Multimap<String, String> getMergeableParams() {
        return this.convertToMultiMap(this.mergeableParams);
    }

    private Multimap<String, String> convertToMultiMap(PObject objectParams) {
        HashMultimap params = HashMultimap.create();
        if (objectParams != null) {
            Iterator<String> customParamsIter = objectParams.keys();
            while (customParamsIter.hasNext()) {
                String key = customParamsIter.next();
                if (objectParams.isArray(key)) {
                    PArray array = objectParams.optArray(key);
                    for (int i = 0; i < array.size(); ++i) {
                        params.put((Object)key, (Object)array.getString(i));
                    }
                    continue;
                }
                params.put((Object)key, (Object)objectParams.optString(key, ""));
            }
        }
        return params;
    }

    @Override
    public String createCommonUrl() throws URISyntaxException, UnsupportedEncodingException {
        return this.getBaseUrl();
    }

    public final void setCustomParam(String name, String value) {
        this.additionalCustomParam.put((Object)name, (Object)value);
    }

    @Override
    public boolean validateBaseUrl() {
        try {
            return new URI(this.getBaseUrl()) != null;
        }
        catch (URISyntaxException exc) {
            return false;
        }
    }
}

