/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeSet;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.Config;
import org.mapfish.print.config.layout.Layout;
import org.mapfish.print.utils.PJsonObject;

public class MapPrinter {
    private final Config config;
    private String configDir;

    public MapPrinter(File config) throws FileNotFoundException {
        this.config = Config.fromYaml(config);
        this.configDir = config.getParent();
        if (this.configDir == null) {
            try {
                this.configDir = new File(".").getCanonicalPath();
            }
            catch (IOException e) {
                this.configDir = ".";
            }
        }
        this.initFonts();
    }

    public MapPrinter(InputStream instreamConfig, String configDir) {
        this.config = Config.fromInputStream(instreamConfig);
        this.configDir = configDir;
        this.initFonts();
    }

    public MapPrinter(String strConfig, String configDir) {
        this.config = Config.fromString(strConfig);
        this.configDir = configDir;
        this.initFonts();
    }

    private void initFonts() {
        FontFactory.defaultEmbedding = true;
        TreeSet<String> fontPaths = this.config.getFonts();
        if (fontPaths != null) {
            for (String fontPath : fontPaths) {
                File fontFile = new File(fontPath = fontPath.replaceAll("\\$\\{configDir\\}", this.configDir));
                if (fontFile.isDirectory()) {
                    FontFactory.registerDirectory(fontPath, true);
                    continue;
                }
                FontFactory.register(fontPath);
            }
        }
    }

    public RenderingContext print(PJsonObject jsonSpec, OutputStream outFile, String referer) throws DocumentException {
        String layoutName = jsonSpec.getString("layout");
        Layout layout = this.config.getLayout(layoutName);
        if (layout == null) {
            throw new RuntimeException("Unknown layout '" + layoutName + "'");
        }
        Document doc = new Document(layout.getFirstPageSize(null, jsonSpec));
        PdfWriter writer = PdfWriter.getInstance(doc, outFile);
        if (!layout.isSupportLegacyReader()) {
            writer.setFullCompression();
            writer.setPdfVersion(PdfWriter.PDF_VERSION_1_5);
            writer.setCompressionLevel(9);
        }
        RenderingContext context = new RenderingContext(doc, writer, this.config, jsonSpec, this.configDir, layout, referer);
        layout.render(jsonSpec, context);
        doc.close();
        writer.close();
        return context;
    }

    public static PJsonObject parseSpec(String spec) {
        JSONObject jsonSpec;
        try {
            jsonSpec = new JSONObject(spec);
        }
        catch (JSONException e) {
            throw new RuntimeException("Cannot parse the spec file", e);
        }
        return new PJsonObject(jsonSpec, "spec");
    }

    public void printClientConfig(JSONWriter json) throws JSONException {
        this.config.printClientConfig(json);
    }

    public void stop() {
        this.config.stop();
    }

    public String getOutputFilename(String layout, String defaultName) {
        String name = this.config.getOutputFilename(layout);
        return name == null ? defaultName : name;
    }

    public Config getConfig() {
        return this.config;
    }

    static {
        ByteBuffer.HIGH_PRECISION = true;
    }
}

