/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.lowagie.text.pdf.PdfContentByte;
import java.awt.geom.AffineTransform;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.mapfish.print.utils.DistanceUnit;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Transformer
implements Cloneable {
    private static final String GOOGLE_WKT = "PROJCS[\"Google Mercator\",GEOGCS[\"WGS 84\",DATUM[\"World Geodetic System 1984\",SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic latitude\", NORTH],AXIS[\"Geodetic longitude\", EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"semi_minor\", 6378137.0],PARAMETER[\"latitude_of_origin\", 0.0],PARAMETER[\"central_meridian\", 0.0],PARAMETER[\"scale_factor\", 1.0],PARAMETER[\"false_easting\", 0.0],PARAMETER[\"false_northing\", 0.0],UNIT[\"m\", 1.0],AXIS[\"Easting\", EAST],AXIS[\"Northing\", NORTH],AUTHORITY[\"EPSG\",\"900913\"]]";
    private float svgFactor = 1.0f;
    public float minGeoX;
    public float minGeoY;
    public float maxGeoX;
    public float maxGeoY;
    private final int scale;
    private final float paperWidth;
    private final float paperHeight;
    private float pixelPerGeoUnit;
    private float paperPosX;
    private float paperPosY;
    private final int dpi;
    private double rotation;

    public Transformer(float centerX, float centerY, float paperWidth, float paperHeight, int scale, int dpi, DistanceUnit unitEnum, double rotation, String geodeticSRS, boolean isIntegerSvg) {
        this.dpi = dpi;
        this.pixelPerGeoUnit = (float)(unitEnum.convertTo(dpi, DistanceUnit.IN) / (double)scale);
        float geoWidth = paperWidth * (float)dpi / 72.0f / this.pixelPerGeoUnit;
        float geoHeight = paperHeight * (float)dpi / 72.0f / this.pixelPerGeoUnit;
        if (isIntegerSvg) {
            this.svgFactor = dpi < 600 ? 8.333333f : (float)dpi / 72.0f;
        }
        this.paperWidth = paperWidth;
        this.paperHeight = paperHeight;
        this.scale = scale;
        this.rotation = rotation;
        if (geodeticSRS != null) {
            this.computeGeodeticBBox(geoWidth, geoHeight, centerX, centerY, dpi, geodeticSRS);
        } else {
            this.minGeoX = centerX - geoWidth / 2.0f;
            this.minGeoY = centerY - geoHeight / 2.0f;
            this.maxGeoX = this.minGeoX + geoWidth;
            this.maxGeoY = this.minGeoY + geoHeight;
        }
    }

    private void computeGeodeticBBox(float geoWidth, float geoHeight, float centerX, float centerY, float dpi, String srsCode) {
        try {
            CoordinateReferenceSystem crs = srsCode.equalsIgnoreCase("EPSG:900913") ? CRS.parseWKT(GOOGLE_WKT) : CRS.decode(srsCode, true);
            GeodeticCalculator calc = new GeodeticCalculator(crs);
            DirectPosition2D directPosition2D = new DirectPosition2D(centerX, centerY);
            directPosition2D.setCoordinateReferenceSystem(crs);
            calc.setStartingPosition(directPosition2D);
            calc.setDirection(-90.0, geoWidth / 2.0f);
            this.minGeoX = (float)calc.getDestinationPosition().getOrdinate(0);
            calc.setDirection(90.0, geoWidth / 2.0f);
            this.maxGeoX = (float)calc.getDestinationPosition().getOrdinate(0);
            calc.setDirection(180.0, geoHeight / 2.0f);
            this.minGeoY = (float)calc.getDestinationPosition().getOrdinate(1);
            calc.setDirection(0.0, geoHeight / 2.0f);
            this.maxGeoY = (float)calc.getDestinationPosition().getOrdinate(1);
            this.pixelPerGeoUnit = this.paperWidth * dpi / 72.0f / (this.maxGeoX - this.minGeoX);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public float getGeoW() {
        return this.maxGeoX - this.minGeoX;
    }

    public float getGeoH() {
        return this.maxGeoY - this.minGeoY;
    }

    public float getStraightBitmapW() {
        return this.getGeoW() * this.pixelPerGeoUnit;
    }

    public float getStraightBitmapH() {
        return this.getGeoH() * this.pixelPerGeoUnit;
    }

    public long getRotatedBitmapW() {
        double width = this.getStraightBitmapW();
        if (this.rotation != 0.0) {
            double height = this.getStraightBitmapH();
            width = Math.abs(width * Math.cos(this.rotation)) + Math.abs(height * Math.sin(this.rotation));
        }
        return Math.round(width);
    }

    public long getRotatedBitmapH() {
        double height = this.getStraightBitmapH();
        if (this.rotation != 0.0) {
            double width = this.getStraightBitmapW();
            height = Math.abs(height * Math.cos(this.rotation)) + Math.abs(width * Math.sin(this.rotation));
        }
        return Math.round(height);
    }

    public float getRotatedGeoW() {
        float width = this.getGeoW();
        if (this.rotation != 0.0) {
            float height = this.getGeoH();
            width = (float)(Math.abs((double)width * Math.cos(this.rotation)) + Math.abs((double)height * Math.sin(this.rotation)));
        }
        return width;
    }

    public float getRotatedGeoH() {
        float height = this.getGeoH();
        if (this.rotation != 0.0) {
            float width = this.getGeoW();
            height = (float)(Math.abs((double)height * Math.cos(this.rotation)) + Math.abs((double)width * Math.sin(this.rotation)));
        }
        return height;
    }

    public float getRotatedPaperW() {
        float width = this.getPaperW();
        if (this.rotation != 0.0) {
            float height = this.getPaperH();
            width = (float)(Math.abs((double)width * Math.cos(this.rotation)) + Math.abs((double)height * Math.sin(this.rotation)));
        }
        return width;
    }

    public float getRotatedPaperH() {
        float height = this.getPaperH();
        if (this.rotation != 0.0) {
            float width = this.getPaperW();
            height = (float)(Math.abs((double)height * Math.cos(this.rotation)) + Math.abs((double)width * Math.sin(this.rotation)));
        }
        return height;
    }

    public float getRotatedMinGeoX() {
        return this.minGeoX - (this.getRotatedGeoW() - this.getGeoW()) / 2.0f;
    }

    public float getRotatedMaxGeoX() {
        return this.maxGeoX + (this.getRotatedGeoW() - this.getGeoW()) / 2.0f;
    }

    public float getRotatedMinGeoY() {
        return this.minGeoY - (this.getRotatedGeoH() - this.getGeoH()) / 2.0f;
    }

    public float getRotatedMaxGeoY() {
        return this.maxGeoY + (this.getRotatedGeoH() - this.getGeoH()) / 2.0f;
    }

    public long getRotatedSvgW() {
        return (long)((float)this.getRotatedBitmapW() * this.svgFactor);
    }

    public long getRotatedSvgH() {
        return (long)((float)this.getRotatedBitmapH() * this.svgFactor);
    }

    public long getStraightSvgW() {
        return (long)(this.getStraightBitmapW() * this.svgFactor);
    }

    public long getStraightSvgH() {
        return (long)(this.getStraightBitmapH() * this.svgFactor);
    }

    public float getPaperW() {
        return this.paperWidth;
    }

    public float getPaperH() {
        return this.paperHeight;
    }

    public void setMapPos(float x, float y) {
        this.paperPosX = x;
        this.paperPosY = y;
    }

    public float getPaperPosX() {
        return this.paperPosX;
    }

    public float getPaperPosY() {
        return this.paperPosY;
    }

    public AffineTransform getBaseTransform() {
        AffineTransform result = AffineTransform.getTranslateInstance(this.paperPosX, this.paperPosY);
        if (this.rotation != 0.0) {
            result.translate(this.getPaperW() / 2.0f, this.getPaperH() / 2.0f);
            result.rotate(this.rotation);
            result.translate(-this.getRotatedPaperW() / 2.0f, -this.getRotatedPaperH() / 2.0f);
        }
        return result;
    }

    public AffineTransform getGeoTransform(boolean reverseRotation) {
        AffineTransform result = AffineTransform.getTranslateInstance(this.paperPosX, this.paperPosY);
        if (this.rotation != 0.0) {
            result.rotate((double)(reverseRotation ? -1 : 1) * this.rotation, this.getPaperW() / 2.0f, this.getPaperH() / 2.0f);
        }
        result.scale(this.getPaperW() / this.getGeoW(), this.getPaperH() / this.getGeoH());
        result.translate(-this.minGeoX, -this.minGeoY);
        return result;
    }

    public AffineTransform getSvgTransform() {
        AffineTransform result = this.getBaseTransform();
        result.scale(this.getPaperW() / (float)this.getStraightSvgW(), this.getPaperH() / (float)this.getStraightSvgH());
        return result;
    }

    public AffineTransform getPdfTransform() {
        AffineTransform result = this.getBaseTransform();
        result.scale(this.getPaperW() / this.getStraightBitmapW(), this.getPaperH() / this.getStraightBitmapH());
        return result;
    }

    public AffineTransform getBitmapTransform() {
        return this.getPdfTransform();
    }

    public int getScale() {
        return this.scale;
    }

    public void zoom(Transformer mainTransformer, float factor) {
        float destH;
        float destW = mainTransformer.getGeoW() / factor;
        if (destW / (destH = mainTransformer.getGeoH() / factor) > this.getGeoW() / this.getGeoH()) {
            destH = this.getGeoH() * destW / this.getGeoW();
        } else {
            destW = this.getGeoW() * destH / this.getGeoH();
        }
        float cX = (this.minGeoX + this.maxGeoX) / 2.0f;
        float cY = (this.minGeoY + this.maxGeoY) / 2.0f;
        this.pixelPerGeoUnit = this.pixelPerGeoUnit * this.getGeoW() / destW;
        this.minGeoX = cX - destW / 2.0f;
        this.maxGeoX = cX + destW / 2.0f;
        this.minGeoY = cY - destH / 2.0f;
        this.maxGeoY = cY + destH / 2.0f;
    }

    public Transformer clone() {
        try {
            return (Transformer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public float getMinGeoX() {
        return this.minGeoX;
    }

    public float getMinGeoY() {
        return this.minGeoY;
    }

    public float getMaxGeoX() {
        return this.maxGeoX;
    }

    public float getMaxGeoY() {
        return this.maxGeoY;
    }

    public float getSvgFactor() {
        return this.svgFactor;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setClipping(PdfContentByte dc) {
        dc.rectangle(this.paperPosX, this.paperPosY, this.paperWidth, this.paperHeight);
        dc.clip();
        dc.newPath();
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public float getResolution() {
        return 1.0f / this.pixelPerGeoUnit;
    }

    public void setResolution(float resolution) {
        this.pixelPerGeoUnit = 1.0f / resolution;
    }

    public int getDpi() {
        return this.dpi;
    }
}

