/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonObject;
import org.pvalsecc.misc.MatchAllSet;
import org.pvalsecc.misc.URIUtils;

public abstract class HTTPMapReader
extends MapReader {
    public static final Logger LOGGER = Logger.getLogger(HTTPMapReader.class);
    protected final RenderingContext context;
    protected final PJsonObject params;
    protected final URI baseUrl;
    public static final Set<String> OVERRIDE_ALL = new MatchAllSet<String>();

    protected HTTPMapReader(RenderingContext context, PJsonObject params) {
        super(params);
        this.context = context;
        this.params = params;
        try {
            this.baseUrl = new URI(params.getString("baseURL"));
        }
        catch (Exception e) {
            throw new InvalidJsonValueException(params, "baseURL", params.getString("baseURL"), e);
        }
        this.checkSecurity(params);
    }

    private void checkSecurity(PJsonObject params) {
        try {
            if (!this.context.getConfig().validateUri(this.baseUrl)) {
                throw new InvalidJsonValueException(params, "baseURL", this.baseUrl);
            }
        }
        catch (Exception e) {
            throw new InvalidJsonValueException(params, "baseURL", this.baseUrl, e);
        }
    }

    @Override
    public void render(Transformer transformer, ParallelMapTileLoader parallelMapTileLoader, String srs, boolean first) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        try {
            PJsonObject customParams = this.params.optJSONObject("customParams");
            if (customParams != null) {
                Iterator<String> customParamsIt = customParams.keys();
                while (customParamsIt.hasNext()) {
                    String key = customParamsIt.next();
                    URIUtils.addParam(queryParams, key, customParams.getString(key));
                }
            }
            TileRenderer formater = TileRenderer.get(this.getFormat());
            this.addCommonQueryParams(queryParams, transformer, srs, first);
            URI commonUri = URIUtils.addParams(this.baseUrl, queryParams, OVERRIDE_ALL);
            this.renderTiles(formater, transformer, commonUri, parallelMapTileLoader);
        }
        catch (Exception e) {
            this.context.addError(e);
        }
    }

    protected abstract void renderTiles(TileRenderer var1, Transformer var2, URI var3, ParallelMapTileLoader var4) throws IOException, URISyntaxException;

    protected abstract TileRenderer.Format getFormat();

    protected abstract void addCommonQueryParams(Map<String, List<String>> var1, Transformer var2, String var3, boolean var4);

    @Override
    public boolean canMerge(MapReader other) {
        if (this.opacity != other.opacity) {
            return false;
        }
        if (other instanceof HTTPMapReader) {
            HTTPMapReader http = (HTTPMapReader)other;
            PJsonObject customParams = this.params.optJSONObject("customParams");
            PJsonObject customParamsOther = http.params.optJSONObject("customParams");
            return this.baseUrl.equals(http.baseUrl) && (customParams != null ? customParams.equals(customParamsOther) : customParamsOther == null);
        }
        return false;
    }
}

