/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.HTTPMapReader;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;
import org.pvalsecc.misc.StringUtils;
import org.pvalsecc.misc.URIUtils;

public class MapServerMapReader
extends HTTPMapReader {
    private final String format;
    protected final List<String> layers = new ArrayList<String>();

    private MapServerMapReader(String layer, RenderingContext context, PJsonObject params) {
        super(context, params);
        this.layers.add(layer);
        this.format = params.getString("format");
    }

    @Override
    protected void renderTiles(TileRenderer formatter, Transformer transformer, URI commonUri, ParallelMapTileLoader parallelMapTileLoader) throws IOException {
        ArrayList<URI> uris = new ArrayList<URI>(1);
        uris.add(commonUri);
        formatter.render(transformer, uris, parallelMapTileLoader, this.context, this.opacity, 1, 0.0f, 0.0f, transformer.getRotatedBitmapW(), transformer.getRotatedBitmapH());
    }

    @Override
    protected TileRenderer.Format getFormat() {
        if (this.format.equals("image/svg+xml")) {
            return TileRenderer.Format.SVG;
        }
        if (this.format.equals("application/x-pdf")) {
            return TileRenderer.Format.PDF;
        }
        return TileRenderer.Format.BITMAP;
    }

    @Override
    protected void addCommonQueryParams(Map<String, List<String>> result, Transformer transformer, String srs, boolean first) {
        long h;
        long w;
        URIUtils.addParamOverride(result, "map_angle", String.valueOf(-Math.toDegrees(transformer.getRotation())));
        transformer.setRotation(0.0);
        if (this.format.equals("image/svg+xml")) {
            URIUtils.addParamOverride(result, "map_imagetype", "svg");
            w = transformer.getRotatedSvgW();
            h = transformer.getRotatedSvgH();
        } else if (this.format.equals("application/x-pdf")) {
            URIUtils.addParamOverride(result, "MAP_IMAGETYPE", "pdf");
            w = transformer.getRotatedBitmapW();
            h = transformer.getRotatedBitmapH();
        } else {
            URIUtils.addParamOverride(result, "MAP_IMAGETYPE", "png");
            w = transformer.getRotatedBitmapW();
            h = transformer.getRotatedBitmapH();
        }
        URIUtils.addParamOverride(result, "MODE", "map");
        URIUtils.addParamOverride(result, "LAYERS", StringUtils.join(this.layers, " "));
        URIUtils.addParamOverride(result, "MAP_SIZE", String.format("%d %d", w, h));
        URIUtils.addParamOverride(result, "MAPEXT", String.format("%s %s %s %s", Float.valueOf(transformer.getRotatedMinGeoX()), Float.valueOf(transformer.getRotatedMinGeoY()), Float.valueOf(transformer.getRotatedMaxGeoX()), Float.valueOf(transformer.getRotatedMaxGeoY())));
        URIUtils.addParamOverride(result, "map_resolution", String.valueOf(transformer.getDpi()));
        if (!first) {
            URIUtils.addParamOverride(result, "TRANSPARENT", "true");
        }
    }

    protected static void create(List<MapReader> target, RenderingContext context, PJsonObject params) {
        PJsonArray layers = params.getJSONArray("layers");
        for (int i = 0; i < layers.size(); ++i) {
            String layer = layers.getString(i);
            target.add(new MapServerMapReader(layer, context, params));
        }
    }

    @Override
    public boolean testMerge(MapReader other) {
        if (this.canMerge(other)) {
            MapServerMapReader ms = (MapServerMapReader)other;
            this.layers.addAll(ms.layers);
            return true;
        }
        return false;
    }

    @Override
    public boolean canMerge(MapReader other) {
        if (!super.canMerge(other)) {
            return false;
        }
        if (other instanceof MapServerMapReader) {
            MapServerMapReader wms = (MapServerMapReader)other;
            return this.format.equals(wms.format);
        }
        return false;
    }

    @Override
    public String toString() {
        return StringUtils.join(this.layers, ", ");
    }
}

