/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.utils.PJsonArray;

public class TileCacheLayerInfo {
    protected static final Pattern FORMAT_REGEXP = Pattern.compile("^[^/]+/([^/]+)$");
    protected static final Pattern RESOLUTIONS_REGEXP = Pattern.compile("\\s+");
    protected final int width;
    protected final int height;
    protected final float[] resolutions;
    protected final float minX;
    protected final float minY;
    protected final float maxX;
    protected final float maxY;
    protected String extension;

    protected float resolutionTolerance() {
        return 1.05f;
    }

    public TileCacheLayerInfo(String resolutions, int width, int height, float minX, float minY, float maxX, float maxY, String format) {
        String[] resolutionsTxt = RESOLUTIONS_REGEXP.split(resolutions);
        this.resolutions = new float[resolutionsTxt.length];
        for (int i = 0; i < resolutionsTxt.length; ++i) {
            this.resolutions[i] = Float.parseFloat(resolutionsTxt[i]);
        }
        this.sortResolutions();
        this.width = width;
        this.height = height;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        if (format != null) {
            Matcher formatMatcher = FORMAT_REGEXP.matcher(format);
            if (formatMatcher.matches()) {
                this.extension = formatMatcher.group(1).toLowerCase();
                if (this.extension.equals("jpg")) {
                    this.extension = "jpeg";
                }
            } else {
                throw new InvalidValueException("format", format);
            }
        }
    }

    public TileCacheLayerInfo(PJsonArray resolutions, int width, int height, float minX, float minY, float maxX, float maxY, String extension) {
        this.resolutions = new float[resolutions.size()];
        for (int i = 0; i < resolutions.size(); ++i) {
            this.resolutions[i] = resolutions.getFloat(i);
        }
        this.sortResolutions();
        this.width = width;
        this.height = height;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.extension = extension;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ResolutionInfo getNearestResolution(float targetResolution) {
        int pos = this.resolutions.length - 1;
        float result = this.resolutions[pos];
        float tolerance = this.resolutionTolerance();
        for (int i = this.resolutions.length - 1; i >= 0; --i) {
            float cur = this.resolutions[i];
            if (!(cur <= targetResolution * tolerance)) continue;
            result = cur;
            pos = i;
            if (cur == targetResolution) break;
        }
        return new ResolutionInfo(pos, result);
    }

    public float[] getResolutions() {
        return this.resolutions;
    }

    public String getExtension() {
        return this.extension;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TileCacheLayerInfo");
        sb.append("{width=").append(this.width);
        sb.append(", height=").append(this.height);
        sb.append(", minX=").append(this.minX);
        sb.append(", minY=").append(this.minY);
        sb.append(", maxX=").append(this.maxX);
        sb.append(", maxY=").append(this.maxY);
        sb.append(", extension='").append(this.extension).append('\'');
        sb.append(", resolutions=").append(this.resolutions == null ? "null" : "");
        for (int i = 0; this.resolutions != null && i < this.resolutions.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.resolutions[i]);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean isVisible(float x1, float y1, float x2, float y2) {
        return x1 >= this.minX && x1 <= this.maxX && y1 >= this.minY && y1 <= this.maxY;
    }

    private void sortResolutions() {
        Arrays.sort(this.resolutions);
        int right = this.resolutions.length - 1;
        for (int left = 0; left < right; ++left, --right) {
            float temp = this.resolutions[left];
            this.resolutions[left] = this.resolutions[right];
            this.resolutions[right] = temp;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TileCacheLayerInfo that = (TileCacheLayerInfo)o;
        if (this.height != that.height) {
            return false;
        }
        if (Float.compare(that.maxX, this.maxX) != 0) {
            return false;
        }
        if (Float.compare(that.maxY, this.maxY) != 0) {
            return false;
        }
        if (Float.compare(that.minX, this.minX) != 0) {
            return false;
        }
        if (Float.compare(that.minY, this.minY) != 0) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (!this.extension.equals(that.extension)) {
            return false;
        }
        return Arrays.equals(this.resolutions, that.resolutions);
    }

    public static class ResolutionInfo {
        public final int index;
        public final float value;

        public ResolutionInfo(int index, float value) {
            this.index = index;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolutionInfo that = (ResolutionInfo)o;
            return this.index == that.index && Float.compare(that.value, this.value) == 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ResolutionInfo");
            sb.append("{index=").append(this.index);
            sb.append(", result=").append(this.value);
            sb.append('}');
            return sb.toString();
        }
    }
}

