/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.DOMUtil;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.map.readers.HTTPMapReader;
import org.mapfish.print.map.readers.TileCacheLayerInfo;
import org.pvalsecc.misc.URIUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WMSServerInfo {
    private static final Log LOGGER = LogFactory.getLog(WMSServerInfo.class);
    private static final Map<URI, WMSServerInfo> cache = Collections.synchronizedMap(new HashMap());
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private Map<String, TileCacheLayerInfo> tileCacheLayers = null;

    public static synchronized void clearCache() {
        cache.clear();
    }

    public static WMSServerInfo getInfo(URI uri, RenderingContext context) {
        WMSServerInfo result = cache.get(uri);
        if (result == null) {
            return WMSServerInfo.getInfoImpl(uri, context);
        }
        return result;
    }

    private static synchronized WMSServerInfo getInfoImpl(URI uri, RenderingContext context) {
        WMSServerInfo result = cache.get(uri);
        if (result == null) {
            try {
                result = WMSServerInfo.requestInfo(uri, context);
            }
            catch (Exception e) {
                LOGGER.info("Error while getting capabilities for " + uri + ". The print module will assume it's a standard WMS.");
                String stackTrace = "";
                for (StackTraceElement el : e.getStackTrace()) {
                    stackTrace = stackTrace + el.toString() + "\n";
                }
                LOGGER.info(stackTrace);
                result = new WMSServerInfo();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("GetCapabilities " + uri + ": " + result);
            }
            cache.put(uri, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WMSServerInfo requestInfo(URI baseUrl, RenderingContext context) throws IOException, URISyntaxException, ParserConfigurationException, SAXException {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        URIUtils.addParamOverride(queryParams, "SERVICE", "WMS");
        URIUtils.addParamOverride(queryParams, "REQUEST", "GetCapabilities");
        URIUtils.addParamOverride(queryParams, "VERSION", "1.1.1");
        URL url = URIUtils.addParams(baseUrl, queryParams, HTTPMapReader.OVERRIDE_ALL).toURL();
        HttpMethodBase method = null;
        try {
            WMSServerInfo result;
            InputStream stream;
            if ((url.getProtocol().equals("http") || url.getProtocol().equals("https")) && context.getConfig().localHostForwardIsFrom(url.getHost())) {
                String scheme = url.getProtocol();
                String host = url.getHost();
                if (url.getProtocol().equals("https") && context.getConfig().localHostForwardIsHttps2http()) {
                    scheme = "http";
                }
                URL localUrl = new URL(scheme, "localhost", url.getPort(), url.getFile());
                HttpURLConnection connexion = (HttpURLConnection)localUrl.openConnection();
                connexion.setRequestProperty("Host", host);
                stream = connexion.getInputStream();
            } else {
                method = new GetMethod(url.toString());
                if (context.getReferer() != null) {
                    method.setRequestHeader("Referer", context.getReferer());
                }
                context.getConfig().getHttpClient(baseUrl).executeMethod(method);
                int code = method.getStatusCode();
                if (code < 200 || code >= 300) {
                    throw new IOException("Error " + code + " while reading the Capabilities from " + url + ": " + method.getStatusText());
                }
                stream = method.getResponseBodyAsStream();
            }
            try {
                result = WMSServerInfo.parseCapabilities(stream);
            }
            finally {
                stream.close();
            }
            WMSServerInfo wMSServerInfo = result;
            return wMSServerInfo;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    protected static WMSServerInfo parseCapabilities(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        Document doc = documentBuilder.parse(stream);
        NodeList tileSets = doc.getElementsByTagName("TileSet");
        boolean isTileCache = tileSets.getLength() > 0;
        WMSServerInfo result = new WMSServerInfo();
        if (isTileCache) {
            result.tileCacheLayers = new HashMap<String, TileCacheLayerInfo>();
            NodeList layers = doc.getElementsByTagName("Layer");
            for (int i = 0; i < tileSets.getLength(); ++i) {
                Node tileSet = tileSets.item(i);
                Node layer = layers.item(i + 1);
                String resolutions = DOMUtil.getChildText(DOMUtil.getFirstChildElement(tileSet, "Resolutions"));
                int width = Integer.parseInt(DOMUtil.getChildText(DOMUtil.getFirstChildElement(tileSet, "Width")));
                int height = Integer.parseInt(DOMUtil.getChildText(DOMUtil.getFirstChildElement(tileSet, "Height")));
                Element bbox = DOMUtil.getFirstChildElement(layer, "BoundingBox");
                float minX = Float.parseFloat(DOMUtil.getAttrValue(bbox, "minx"));
                float minY = Float.parseFloat(DOMUtil.getAttrValue(bbox, "miny"));
                float maxX = Float.parseFloat(DOMUtil.getAttrValue(bbox, "maxx"));
                float maxY = Float.parseFloat(DOMUtil.getAttrValue(bbox, "maxy"));
                String format = DOMUtil.getChildText(DOMUtil.getFirstChildElement(tileSet, "Format"));
                String layerName = DOMUtil.getChildText(DOMUtil.getFirstChildElement(layer, "Name"));
                TileCacheLayerInfo info = new TileCacheLayerInfo(resolutions, width, height, minX, minY, maxX, maxY, format);
                result.tileCacheLayers.put(layerName, info);
            }
        }
        return result;
    }

    public boolean isTileCache() {
        return this.tileCacheLayers != null;
    }

    public TileCacheLayerInfo getTileCacheLayer(String layerName) {
        return this.tileCacheLayers != null ? this.tileCacheLayers.get(layerName) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WMSServerInfo");
        sb.append("{tileCacheLayers=").append(this.tileCacheLayers);
        sb.append('}');
        return sb.toString();
    }

    static {
        documentBuilderFactory.setValidating(false);
    }
}

