/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.renderers;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.MapTileTask;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.renderers.TileRenderer;

public class BitmapTileRenderer
extends TileRenderer {
    private static final Log LOGGER = LogFactory.getLog(BitmapTileRenderer.class);

    @Override
    public void render(Transformer transformer, List<URI> uris, ParallelMapTileLoader parallelMapTileLoader, final RenderingContext context, final float opacity, int nbTilesHorizontal, float offsetX, float offsetY, final long bitmapTileW, final long bitmapTileH) throws IOException {
        final AffineTransform bitmapTransformer = transformer.getBitmapTransform();
        double rotation = transformer.getRotation();
        for (int i = 0; i < uris.size(); ++i) {
            final URI uri = uris.get(i);
            if (uri == null) continue;
            int line = i / nbTilesHorizontal;
            int col = i % nbTilesHorizontal;
            final float posX = 0.0f - offsetX + (float)((long)col * bitmapTileW);
            final float posY = 0.0f - offsetY + (float)((long)line * bitmapTileH);
            if (rotation != 0.0 && !this.isTileVisible(posX, posY, bitmapTileW, bitmapTileH, bitmapTransformer, transformer)) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Not needed: " + uri);
                continue;
            }
            parallelMapTileLoader.addTileToLoad(new MapTileTask(){
                public Image map;

                @Override
                protected void readTile() throws IOException, DocumentException {
                    this.map = PDFUtils.getImage(context, uri, bitmapTileW, bitmapTileH);
                    this.map.setAbsolutePosition(posX, posY);
                }

                @Override
                protected void renderOnPdf(PdfContentByte dc) throws DocumentException {
                    dc.transform(bitmapTransformer);
                    if ((double)opacity < 1.0) {
                        PdfGState gs = new PdfGState();
                        gs.setFillOpacity(opacity);
                        gs.setStrokeOpacity(opacity);
                        dc.setGState(gs);
                    }
                    dc.addImage(this.map);
                }
            });
        }
    }

    private boolean isTileVisible(float x, float y, long w, long h, AffineTransform bitmapTransformer, Transformer transformer) {
        GeometryFactory gf = new GeometryFactory();
        Polygon page = gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(transformer.getPaperPosX(), transformer.getPaperPosY()), new Coordinate(transformer.getPaperPosX() + transformer.getPaperW(), transformer.getPaperPosY()), new Coordinate(transformer.getPaperPosX() + transformer.getPaperW(), transformer.getPaperPosY() + transformer.getPaperH()), new Coordinate(transformer.getPaperPosX(), transformer.getPaperPosY() + transformer.getPaperH()), new Coordinate(transformer.getPaperPosX(), transformer.getPaperPosY())}), null);
        Point2D.Float ll = new Point2D.Float();
        Point2D.Float lr = new Point2D.Float();
        Point2D.Float ur = new Point2D.Float();
        Point2D.Float ul = new Point2D.Float();
        bitmapTransformer.transform(new Point2D.Float(x, y), ll);
        bitmapTransformer.transform(new Point2D.Float(x + (float)w, y), lr);
        bitmapTransformer.transform(new Point2D.Float(x + (float)w, y + (float)h), ur);
        bitmapTransformer.transform(new Point2D.Float(x, y + (float)h), ul);
        Polygon tile = gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(ll.getX(), ll.getY()), new Coordinate(lr.getX(), lr.getY()), new Coordinate(ur.getX(), ur.getY()), new Coordinate(ul.getX(), ul.getY()), new Coordinate(ll.getX(), ll.getY())}), null);
        return page.intersects(tile);
    }
}

