/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.renderers;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.log4j.Logger;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.MapTileTask;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.renderers.TileRenderer;

public class PDFTileRenderer
extends TileRenderer {
    public static final Logger LOGGER = Logger.getLogger(PDFTileRenderer.class);

    @Override
    public void render(final Transformer transformer, List<URI> uris, ParallelMapTileLoader parallelMapTileLoader, final RenderingContext context, final float opacity, int nbTilesHorizontal, float offsetX, float offsetY, long bitmapTileW, long bitmapTileH) throws IOException {
        if (uris.size() != 1) {
            throw new InvalidValueException("format", "application/x-pdf");
        }
        final URI uri = uris.get(0);
        parallelMapTileLoader.addTileToLoad(new MapTileTask(){
            public PdfImportedPage pdfMap;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void readTile() throws IOException, DocumentException {
                LOGGER.debug(uri);
                PdfReader reader = new PdfReader(uri.toURL());
                Object object = context.getPdfLock();
                synchronized (object) {
                    this.pdfMap = context.getWriter().getImportedPage(reader, 1);
                    if ((double)opacity < 1.0) {
                        PdfGState gs = new PdfGState();
                        gs.setFillOpacity(opacity);
                        gs.setStrokeOpacity(opacity);
                        this.pdfMap.setGState(gs);
                    }
                }
            }

            @Override
            protected void renderOnPdf(PdfContentByte dc) throws DocumentException {
                dc.transform(transformer.getPdfTransform());
                dc.addTemplate(this.pdfMap, 0.0f, 0.0f);
            }
        });
    }
}

