/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.TimeLogger;
import org.mapfish.print.output.AbstractImageFormat;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.output.OutputFormatFactory;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class ImageOutputImageMagickFactory
implements OutputFormatFactory {
    @Override
    public List<String> formats() {
        return Collections.singletonList("png");
    }

    @Override
    public OutputFormat create(String format) {
        return new ImageOutput(format);
    }

    @Override
    public String enablementStatus() {
        return null;
    }

    public static class ImageOutput
    extends AbstractImageFormat {
        public static final Logger LOGGER = Logger.getLogger(ImageOutput.class);

        public ImageOutput(String format) {
            super(format);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RenderingContext print(MapPrinter printer, PJsonObject jsonSpec, OutputStream out, String referer) throws DocumentException {
            PJsonArray layers = jsonSpec.getJSONArray("layers");
            double a = -0.3;
            double b = 0.9;
            double c = 0.4;
            for (int i = 0; i < layers.size(); ++i) {
                PJsonObject layer = layers.getJSONObject(i);
                if (!layer.has("opacity")) continue;
                double opacity = layer.getDouble("opacity");
                opacity = -0.3 * opacity * opacity + 0.9 * opacity + 0.4;
                try {
                    layer.getInternalObj().put("opacity", opacity);
                    continue;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            File tmpPdfFile = null;
            File tmpPngFile = null;
            try {
                RenderingContext context;
                TimeLogger timeLog;
                tmpPdfFile = File.createTempFile("mapfishprint", ".pdf");
                FileOutputStream tmpOut = new FileOutputStream(tmpPdfFile);
                try {
                    timeLog = TimeLogger.info(LOGGER, "PDF Creation");
                    context = printer.print(jsonSpec, tmpOut, referer);
                    timeLog.done();
                }
                finally {
                    tmpOut.close();
                }
                timeLog = TimeLogger.info(LOGGER, "Pdf to image conversion");
                tmpPngFile = File.createTempFile("mapfishprint", ".png");
                this.createImage(jsonSpec, tmpPdfFile, tmpPngFile, context);
                timeLog.done();
                timeLog = TimeLogger.info(LOGGER, "Write Image");
                this.drawImage(out, tmpPngFile);
                timeLog.done();
                RenderingContext renderingContext = context;
                return renderingContext;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (tmpPdfFile != null) {
                    if (!tmpPdfFile.delete()) {
                        LOGGER.warn(tmpPdfFile + " was not able to be deleted for unknown reason.  Will try again on shutdown");
                    }
                    tmpPdfFile.deleteOnExit();
                }
                if (tmpPngFile != null) {
                    if (!tmpPngFile.delete()) {
                        LOGGER.warn(tmpPngFile + " was not able to be deleted for unknown reason.  Will try again on shutdown");
                    }
                    tmpPngFile.deleteOnExit();
                }
            }
        }

        private void drawImage(OutputStream out, File tmpPngFile) throws IOException {
            int bytesRead;
            FileInputStream input = new FileInputStream(tmpPngFile);
            byte[] buffer = new byte[10240];
            while ((bytesRead = input.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }

        private void createImage(PJsonObject jsonSpec, File tmpPdfFile, File tmpPngFile, RenderingContext context) throws IOException {
            int dpi = this.calculateDPI(context, jsonSpec);
            String cmd = "/usr/bin/convert -density " + dpi + "x" + dpi + " " + tmpPdfFile.getAbsolutePath() + " " + tmpPngFile.getAbsolutePath();
            LOGGER.info("Run: " + cmd);
            Process p = Runtime.getRuntime().exec(cmd);
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

