/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.scalebar;

import com.lowagie.text.Font;
import com.lowagie.text.pdf.PdfContentByte;
import java.util.List;
import org.mapfish.print.PDFCustomBlocks;
import org.mapfish.print.config.layout.ScalebarBlock;
import org.mapfish.print.scalebar.Label;
import org.mapfish.print.scalebar.ScalebarDrawer;

public class LineScalebarDrawer
extends ScalebarDrawer {
    public LineScalebarDrawer(PDFCustomBlocks customBlocks, ScalebarBlock block, List<Label> labels, int barSize, int labelDistance, int subIntervals, float intervalWidth, Font pdfFont, float leftLabelMargin, float rightLabelMargin, float maxLabelWidth, float maxLabelHeight) {
        super(customBlocks, block, labels, barSize, labelDistance, subIntervals, intervalWidth, pdfFont, leftLabelMargin, rightLabelMargin, maxLabelWidth, maxLabelHeight);
    }

    @Override
    protected void drawBar(PdfContentByte dc) {
        dc.moveTo(0.0f, 0.0f);
        dc.lineTo(0.0f, this.barSize);
        dc.lineTo(this.intervalWidth * (float)this.block.getIntervals(), this.barSize);
        dc.lineTo(this.intervalWidth * (float)this.block.getIntervals(), 0.0f);
        for (int i = 0; i < this.block.getIntervals(); ++i) {
            float pos = (float)i * this.intervalWidth;
            if (i > 0) {
                dc.moveTo(pos, 0.0f);
                dc.lineTo(pos, this.barSize);
            }
            for (int j = 1; j < this.subIntervals; ++j) {
                dc.moveTo(pos += this.intervalWidth / (float)this.subIntervals, this.barSize);
                dc.lineTo(pos, (float)this.barSize / 2.0f);
            }
        }
        dc.stroke();
    }
}

