/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;
import org.mapfish.print.MapPrinter;

public abstract class BaseMapServlet
extends HttpServlet {
    private static final long serialVersionUID = -6342262849725708850L;
    public static final Logger LOGGER = Logger.getLogger(BaseMapServlet.class);
    private MapPrinter printer = null;
    private Map<String, MapPrinter> printers = null;
    private long lastModified = 0L;
    private long defaultLastModified = 0L;
    private Map<String, Long> lastModifieds = null;

    protected synchronized MapPrinter getMapPrinter(String app) throws ServletException {
        String configPath = this.getInitParameter("config");
        if (configPath == null) {
            throw new ServletException("Missing configuration in web.xml 'web-app/servlet/init-param[param-name=config]' or 'web-app/context-param[param-name=config]'");
        }
        File configFile = null;
        if (app != null) {
            if (this.lastModifieds == null) {
                this.lastModifieds = new HashMap<String, Long>();
            }
            this.printer = this.printers instanceof HashMap && this.printers.containsKey(app) ? this.printers.get(app) : null;
            configFile = new File(app + ".yaml");
        } else {
            configFile = new File(configPath);
        }
        if (!configFile.isAbsolute()) {
            configFile = app != null ? new File(this.getServletContext().getRealPath(app + ".yaml")) : new File(this.getServletContext().getRealPath(configPath));
        }
        this.lastModified = app != null ? (this.lastModifieds instanceof HashMap && this.lastModifieds.containsKey(app) ? this.lastModifieds.get(app) : 0L) : this.defaultLastModified;
        boolean forceReload = false;
        if (this.printer != null && this.printer.getConfig().getReloadConfig()) {
            forceReload = true;
        }
        if (forceReload || this.printer != null && configFile.lastModified() != this.lastModified) {
            if (!forceReload) {
                LOGGER.info("Configuration file modified. Reloading...");
            }
            try {
                this.printer.stop();
            }
            catch (NullPointerException npe) {
                LOGGER.info("BaseMapServlet.java: printer was not stopped. This happens when a switch between applications happens.\n" + npe);
            }
            this.printer = null;
            if (app != null) {
                LOGGER.info("Printer for " + app + " stopped");
                this.printers.put(app, null);
            }
        }
        if (this.printer == null) {
            this.lastModified = configFile.lastModified();
            try {
                LOGGER.info("Loading configuration file: " + configFile.getAbsolutePath());
                this.printer = new MapPrinter(configFile);
                if (app != null) {
                    if (this.printers == null) {
                        this.printers = new HashMap<String, MapPrinter>();
                    }
                    this.printers.put(app, this.printer);
                    this.lastModifieds.put(app, this.lastModified);
                } else {
                    this.defaultLastModified = this.lastModified;
                }
            }
            catch (FileNotFoundException e) {
                throw new ServletException("Cannot read configuration file: " + configPath, (Throwable)e);
            }
            catch (Throwable e) {
                LOGGER.error("Error occurred while reading configuration file", e);
            }
        }
        return this.printer;
    }

    public synchronized void destroy() {
        if (this.printer != null) {
            this.printer.stop();
        }
        super.destroy();
    }
}

