/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.utils;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.JsonMissingException;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonElement;

public class PJsonObject
extends PJsonElement {
    private final JSONObject obj;

    public PJsonObject(JSONObject obj, String contextName) {
        this(null, obj, contextName);
    }

    public PJsonObject(PJsonElement parent, JSONObject obj, String contextName) {
        super(parent, contextName);
        this.obj = obj;
    }

    public String optString(String key) {
        return this.optString(key, null);
    }

    public String optString(String key, String defaultValue) {
        return this.obj.optString(key, defaultValue);
    }

    public String getString(String key) {
        String result = this.obj.optString(key, null);
        if (result == null) {
            throw new JsonMissingException(this, key);
        }
        return result;
    }

    public int getInt(String key) {
        Integer result = this.obj.optInt(key, Integer.MIN_VALUE);
        if (result == Integer.MIN_VALUE) {
            throw new JsonMissingException(this, key);
        }
        return result;
    }

    public Integer optInt(String key) {
        int result = this.obj.optInt(key, Integer.MIN_VALUE);
        return result == Integer.MIN_VALUE ? null : Integer.valueOf(result);
    }

    public int optInt(String key, int defaultValue) {
        return this.obj.optInt(key, defaultValue);
    }

    public double getDouble(String key) {
        double result = this.obj.optDouble(key, Double.NaN);
        if (Double.isNaN(result)) {
            throw new JsonMissingException(this, key);
        }
        return result;
    }

    public double optDouble(String key, double defaultValue) {
        return this.obj.optDouble(key, defaultValue);
    }

    public float getFloat(String key) {
        return (float)this.getDouble(key);
    }

    public Float optFloat(String key) {
        double result = this.obj.optDouble(key, Double.NaN);
        if (Double.isNaN(result)) {
            return null;
        }
        return Float.valueOf((float)result);
    }

    public Float optFloat(String key, float defaultValue) {
        return Float.valueOf((float)this.obj.optDouble(key, defaultValue));
    }

    public boolean getBool(String key) {
        try {
            return this.obj.getBoolean(key);
        }
        catch (JSONException e) {
            throw new JsonMissingException(this, key);
        }
    }

    public Boolean optBool(String key) {
        if (this.obj.optString(key) == null) {
            return null;
        }
        return this.obj.optBoolean(key);
    }

    public boolean optBool(String key, boolean defaultValue) {
        return this.obj.optBoolean(key, defaultValue);
    }

    public PJsonObject optJSONObject(String key) {
        JSONObject val = this.obj.optJSONObject(key);
        return val != null ? new PJsonObject(this, val, key) : null;
    }

    public PJsonObject getJSONObject(String key) {
        JSONObject val = this.obj.optJSONObject(key);
        if (val == null) {
            throw new JsonMissingException(this, key);
        }
        return new PJsonObject(this, val, key);
    }

    public PJsonArray getJSONArray(String key) {
        JSONArray val = this.obj.optJSONArray(key);
        if (val == null) {
            throw new JsonMissingException(this, key);
        }
        return new PJsonArray(this, val, key);
    }

    public PJsonArray optJSONArray(String key) {
        JSONArray val = this.obj.optJSONArray(key);
        if (val == null) {
            return null;
        }
        return new PJsonArray(this, val, key);
    }

    public PJsonArray optJSONArray(String key, PJsonArray defaultValue) {
        PJsonArray result = this.optJSONArray(key);
        return result != null ? result : defaultValue;
    }

    public Iterator<String> keys() {
        return this.obj.keys();
    }

    public int size() {
        return this.obj.length();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PJsonObject) {
            PJsonObject other = (PJsonObject)obj;
            if (this.size() != other.size()) {
                return false;
            }
            Iterator<String> iterator = this.keys();
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (other.getString(key).equals(this.getString(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public JSONObject getInternalObj() {
        return this.obj;
    }

    public boolean has(String key) {
        String result = this.obj.optString(key, null);
        return result != null;
    }
}

