/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.comm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pvalsecc.comm.FatalErrorReporter;
import org.pvalsecc.comm.ServerConnection;
import org.pvalsecc.misc.SystemUtilities;
import org.pvalsecc.misc.UnitUtilities;

public abstract class MultiplexedServer
implements Runnable {
    public static final Log LOGGER = LogFactory.getLog(MultiplexedServer.class);
    private boolean stop = false;
    private Selector selector = null;
    private final Object selectorLOCK = new Object();
    private final FatalErrorReporter fatalErrorReporter;
    private InetSocketAddress address;
    private final String threadName;
    private Thread thread = null;
    private final Object socketCreatedLock = new Object();
    private boolean socketCreated = false;
    private long timeSending = 0L;
    private long timeReceiving = 0L;
    private long nbBytesSent = 0L;
    private long nbBytesReceived = 0L;
    private int nbReceived = 0;
    private int nbSent = 0;

    public MultiplexedServer(FatalErrorReporter fatalErrorReporter, InetSocketAddress address, String threadName) {
        this.fatalErrorReporter = fatalErrorReporter;
        this.address = address;
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(long timeout) throws TimeoutException {
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.start();
        long maxWait = System.currentTimeMillis() + timeout;
        Object object = this.socketCreatedLock;
        synchronized (object) {
            while (!this.socketCreated) {
                long toWait = maxWait - System.currentTimeMillis();
                if (toWait <= 0L) {
                    throw new TimeoutException("Could not start the multiplexed server [" + this.threadName + "].");
                }
                try {
                    this.socketCreatedLock.wait(toWait);
                }
                catch (InterruptedException ignored) {}
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.createSocket();
            Object object = this.socketCreatedLock;
            synchronized (object) {
                this.socketCreated = true;
                this.socketCreatedLock.notifyAll();
            }
            while (!this.stop) {
                int nbKeys = 0;
                try {
                    nbKeys = this.selector.select();
                }
                catch (IOException e) {
                    LOGGER.error(e);
                }
                if (nbKeys <= 0) continue;
                Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                while (it.hasNext()) {
                    long startTime;
                    SelectionKey key = it.next();
                    if (key.isAcceptable()) {
                        this.createNewClientConnection(key);
                    } else if (key.isWritable()) {
                        startTime = System.nanoTime();
                        this.readyToSend(key);
                        this.timeSending += System.nanoTime() - startTime;
                    } else if (key.isReadable()) {
                        startTime = System.nanoTime();
                        this.readyToReceive(key);
                        this.timeReceiving += System.nanoTime() - startTime;
                    }
                    it.remove();
                }
            }
        }
        catch (RuntimeException ex) {
            LOGGER.error("The MultiplexedServer [" + this.threadName + "] caught an unexpected exception.", ex);
            this.fatalErrorReporter.report(ex);
        }
        finally {
            if (this.selector != null) {
                for (SelectionKey key : this.selector.keys()) {
                    SystemUtilities.safeClose(key.channel());
                }
                SystemUtilities.safeClose(this.selector);
            }
            LOGGER.info("[" + this.threadName + "] inTime=" + UnitUtilities.toElapsedNanoTime(this.timeReceiving) + " outTime=" + UnitUtilities.toElapsedNanoTime(this.timeSending) + " in=" + this.nbBytesReceived + "B out=" + UnitUtilities.toComputerSize(this.nbBytesSent) + "B inNb=" + this.nbReceived + " outNb=" + this.nbSent);
        }
    }

    private void readyToReceive(SelectionKey key) {
        int size;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        SocketChannel socket = (SocketChannel)key.channel();
        ServerConnection connection = (ServerConnection)key.attachment();
        try {
            size = socket.read(buffer);
        }
        catch (IOException e) {
            connection.error("Cannot receive data", e);
            key.cancel();
            SystemUtilities.safeClose(socket);
            return;
        }
        if (size >= 0) {
            if (size != buffer.position()) {
                throw new RuntimeException("[" + this.threadName + "] Inconsistent buffer: " + size + "!=" + buffer.position());
            }
            this.nbBytesReceived += (long)size;
            ++this.nbReceived;
            buffer.flip();
            connection.received(buffer);
        } else {
            LOGGER.info("[" + this.threadName + "] Connection closed by " + connection);
            connection.closed();
            key.cancel();
        }
    }

    private void readyToSend(SelectionKey key) {
        SocketChannel socket = (SocketChannel)key.channel();
        ServerConnection connection = (ServerConnection)key.attachment();
        try {
            this.nbBytesSent += (long)connection.send(socket);
            ++this.nbSent;
        }
        catch (IOException e) {
            connection.error("Cannot send data", e);
            key.cancel();
            SystemUtilities.safeClose(socket);
        }
    }

    private void createNewClientConnection(SelectionKey key) {
        SelectionKey newKey;
        SocketChannel socket = null;
        try {
            ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
            socket = serverSocketChannel.accept();
        }
        catch (IOException e) {
            LOGGER.error("Cannot accept the connection from a new client", e);
            SystemUtilities.safeClose(socket);
            return;
        }
        try {
            socket.configureBlocking(false);
            newKey = socket.register(this.selector, 1);
        }
        catch (IOException e) {
            LOGGER.error("Cannot add a new client socket to the selector", e);
            SystemUtilities.safeClose(socket);
            return;
        }
        ServerConnection connection = this.newConnection(newKey);
        newKey.attach(connection);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[" + this.threadName + "] New connection from " + connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSocket() {
        while (!this.stop) {
            ServerSocketChannel serverSocketChannel = null;
            try {
                Object object = this.selectorLOCK;
                synchronized (object) {
                    if (!this.stop) {
                        this.selector = Selector.open();
                    }
                }
                if (this.stop) break;
                serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.configureBlocking(false);
                serverSocketChannel.socket().bind(this.address);
                serverSocketChannel.register(this.selector, 16);
                LOGGER.info("[" + this.threadName + "] Start to listen on " + this.address);
                break;
            }
            catch (IOException e) {
                LOGGER.warn("Cannot start to listen on " + this.threadName + " (will try again later)", e);
                SystemUtilities.safeClose(serverSocketChannel);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected abstract ServerConnection newConnection(SelectionKey var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stop = true;
        while (this.thread != null && this.thread.isAlive()) {
            Object object = this.selectorLOCK;
            synchronized (object) {
                if (this.selector != null) {
                    this.selector.wakeup();
                }
            }
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException e) {
                LOGGER.warn(e);
            }
        }
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public InetSocketAddress getConnectingAddress() throws UnknownHostException {
        return new InetSocketAddress(InetAddress.getLocalHost(), this.address.getPort());
    }

    public InetSocketAddress getConnectingAddress(ServerConnection connection) {
        return new InetSocketAddress(((SocketChannel)connection.getKey().channel()).socket().getLocalAddress(), this.address.getPort());
    }
}

