/*
 * Decompiled with CFR 0.152.
 */
package org.pvalsecc.comm;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.pvalsecc.comm.ObjectClientConnection;
import org.pvalsecc.comm.ObjectServerConnection;

public class ObjectObjectClientConnection<OUT, IN>
extends ObjectClientConnection<OUT> {
    public ObjectObjectClientConnection(InetSocketAddress address) throws IOException {
        super(address);
    }

    public IN send(OUT request) throws IOException, ClassNotFoundException {
        this.sendRequest(request);
        ByteBuffer readBuffer = ByteBuffer.allocate(1024);
        int nb = this.socket.read(readBuffer);
        if (nb <= 0) {
            throw new IOException("Message not fully received");
        }
        readBuffer.flip();
        int len = readBuffer.getInt();
        if (len <= readBuffer.remaining()) {
            return (IN)ObjectServerConnection.unmarshall(readBuffer, len);
        }
        ByteBuffer message = ByteBuffer.allocate(len);
        message.put(readBuffer);
        while (message.remaining() > 0) {
            int nb2 = this.socket.read(message);
            if (nb2 > 0) continue;
            throw new IOException("Message not fully received");
        }
        message.flip();
        return (IN)ObjectServerConnection.unmarshall(message, len);
    }

    public void interrupt() throws IOException {
        this.socket.close();
    }
}

